package Pytanie18_3;

import CtCILibrary.AssortedMethods;

public class QuestionAlternate {

	/* Liczba losowa z przedziału od lower do higher (włącznie) */
	public static int rand(int lower, int higher) { 
		return lower + (int)(Math.random() * (higher - lower + 1));
	}
	
	/* Wybieranie M elementów z pierwotnej tablicy;
	 * uwzględniane są tylko elementy od 0 do i (włącznie)*/
	public static int[] pickMRecursively(int[] original, int m, int i) {
		if (i + 1 < m) { // Brak wystarczającej liczby elementów
			return null; 
		} else if (i + 1 == m) { // Przypadek bazowy - kopiowanie do tablicy pierwszych m elementów
			int[] set = new int[m];
			for (int k = 0; k < m; k++) {
				set[k] = original[k];
			}
			return set;
		} else {
			int[] set = pickMRecursively(original, m, i - 1);
			int k = rand(0, i);
			if (k < m) {
				set[k] = original[i];
			}
			return set;
		}
	}	

	/* Wybieranie M elementów z pierwotnej tablicy */
	public static int[] pickMIteratively(int[] original, int m) {
		int[] subset = new int[m];
		
		/* Zapełnianie tablicy subset pierwszą częścią pierwotnej tablicy */
		for (int i = 0; i < m ; i++) {
			subset[i] = original[i];
		}
		
		/* Przejście po pozostałych elementach pierwotnej tablicy */
		for (int i = m; i < original.length; i++) {
			int k = rand(0, i);
			if (k < m) {
				subset[k] = original[i];
			}
		}
		
		return subset;
	}
	
	public static void main(String[] args) {
		int[] cards = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
		System.out.println(AssortedMethods.arrayToString(cards));
		int[] set = pickMIteratively(cards, 4);
		System.out.println(AssortedMethods.arrayToString(set));
	}	

}
