package Wprowadzenie;

import CtCILibrary.AssortedMethods;

public class Quicksort {
	public static void swap(int[] array, int i, int j) {
		int tmp = array[i];
		array[i] = array[j];
		array[j] = tmp;
	}
	
	public static int partition(int arr[], int left, int right) {
		int pivot = arr[(left + right) / 2]; // Wybieranie punktu podziału. Może to być dowolny element
		
		while (left <= right) { // Do czasu przejścia przez całą tablicę.
			// Znajdowanie po lewej stronie elementu, który powinien znaleźć się po prawej
			while (arr[left] < pivot) { 
				left++;
			}
			
			// Znajdowanie po prawej stronie elementu, który należy umieścić po lewej
			while (arr[right] > pivot) {
				right--;
			}
			
			// Przestawianie elementów i przesuwanie obu indeksów
			if (left <= right) {
				swap(arr, left, right);
				left++;
				right--;
			}
		}
		return left; 
	}
	
	public static void quickSort(int arr[], int left, int right) {
		int index = partition(arr, left, right); 
		if (left < index - 1) { // Sortowanie lewej połówki
			quickSort(arr, left, index - 1);
		}
		if (index < right) { // Sortowanie prawej połówki
			quickSort(arr, index, right);
		}
	}
	
	public static void main(String[] args) {
		int[] arr = AssortedMethods.randomArray(20, 0, 20);
		AssortedMethods.printIntArray(arr);	
		quickSort(arr, 0, arr.length - 1);
		AssortedMethods.printIntArray(arr);
	}

}
