package Pytanie5_2;

public class Pytanie {
	public static String printBinary(double num) {
		if (num >= 1 || num <= 0) {
			return "BŁĄD";
		}
	
		StringBuilder binary = new StringBuilder();
		binary.append(".");
		while (num > 0) {
			/* Ustawianie limitu długości: 32 znaki */
			if (binary.length() > 32) {
				return "BŁĄD";
			}
			double r = num * 2;
			if (r >= 1) {
				binary.append(1);
				num = r - 1;
			} else {
				binary.append(0);
				num = r;
			}
		}
		return binary.toString();
	}
	
	public static String printBinary2(double num) {
		if (num >= 1 || num <= 0) {
			return "BŁĄD";
		}
	
		StringBuilder binary = new StringBuilder();
		double frac = 0.5;
		binary.append(".");
		while (num > 0) {
			/* Ustawianie limitu długości: 32 znaki */
			if (binary.length() >= 32) {
				return "BŁĄD";
			}
			if (num >= frac) {
				binary.append(1);
				num -= frac;
			} else {
				binary.append(0);
			}
			frac /= 2;
		}
		return binary.toString();
	}	
	
	public static void main(String[] args) {
		String bs = printBinary(.125);
		System.out.println(bs);
		
		for (int i = 0; i < 1000; i++) {
			double num = i / 1000.0;
			String binary = printBinary(num);
			String binary2 = printBinary2(num);
			if (!binary.equals("BŁĄD") || !binary2.equals("BŁĄD")) {
				System.out.println(num + " : " + binary + " " + binary2);
			}
		}
	}
}
