package Pytanie3_5;

import java.util.Stack;

public class MyQueue<T> {
	Stack<T> stackNewest, stackOldest;
	
	public MyQueue() {
		stackNewest = new Stack<T>();
		stackOldest = new Stack<T>();
	}
	
	public int size() {
		return stackNewest.size() + stackOldest.size();
	}
	
	public void add(T value) {
		// Dodawanie do stosu
		stackNewest.push(value);
	}
	
	/* Przenoszenie elementów ze stackNewest do stackOldest. Zwykle odbywa się to w celu
	 * przeprowadzenia operacji na stackOldest
	 */
	private void shiftStacks() {
		if (stackOldest.isEmpty()) { 
			while (!stackNewest.isEmpty()) {
				stackOldest.push(stackNewest.pop());
			}
		}
	}
	
	public T peek() {
		shiftStacks();
		return stackOldest.peek(); // Sprawdzanie wartości najstarszego elementu
	}
	
	public T remove() {
		shiftStacks();
		return stackOldest.pop(); // Pobieranie najstarszego elementu
	}
}
