package Pytanie18_13;

import java.util.ArrayList;
import java.util.LinkedList;

import CtCILibrary.AssortedMethods;
import CtCILibrary.Trie;

public class Pytanie {
	private int maxWordLength;
	private WordGroup[] groupList ;
	private Trie trieList[];

	public Pytanie(String[] list) {
		groupList = WordGroup.createWordGroups(list);
		maxWordLength = groupList.length;
		// Inicjowanie listy trieList, tak aby drzewo trie dla elementu groupList[i] 
		// było zapisane na i-tej pozycji
		trieList = new Trie[maxWordLength];
	}

	/* Ta funkcja znajduje prostokąt z liter o największej możliwej
	 * powierzchni (długość x wysokość), w którym każdy wiersz czytany
	 * od lewej do prawej tworzy słowo z listy i każda kolumna
	 * czytana od góry do dołu też tworzy słowo z listy
	 */
	public Rectangle maxRectangle() {
		// Wymiany największego możliwego prostokąta
		int maxSize = maxWordLength * maxWordLength; 

		for (int z = maxSize; z > 0; z--) {
			// Znajdowanie wszystkich par i,j (dla i oraz j mniejszych niż maxWordLength), 
			// dla których i * j = z
			for (int i = 1; i <= maxWordLength; i ++ ) {
				if (z % i == 0) {
					int j = z / i;
					if (j <= maxWordLength) {
						// Sprawdzanie, czy można utworzyć prostokąt o wymiarach
						// i x j
						Rectangle rectangle = makeRectangle(i,j);
						if (rectangle != null) {
							return rectangle;
						}
					}
				}
			}
		}
		return null;
	}

	 /* Ta funkcja przyjmuje jako argumenty długość i wysokość prostokąta.  
	  * Następnie próbuje utworzyć prostokąt o tych wymiarach, używając słów
	  * o określonej długości w wierszach, przy czym kolumny mają zawierać 
	  * słowa o podanej wysokości. Funkcja zwraca utworzony w ten sposób
	  * prostokąt, a w razie niepowodzenia - wartość null
	  */
	private Rectangle makeRectangle(int length, int height) {
		if (groupList[length - 1] == null || groupList[height - 1] == null) {
			return null;
		}
		if (trieList[height - 1] == null) {
			ArrayList<String> words = groupList[height - 1].getWords();
			trieList[height - 1] = new Trie(words); 
		}
		return makePartialRectangle(length, height, new Rectangle(length));
	}


	 /* Ta funkcja próbuje rekurencyjnie utworzyć prostokąt ze słów o 
	  * długości l (wiersze) i słów o długości h (kolumny). W tym celu
	  * rozpoczyna od pustego prostokąta i dodaje do niego słowo o długości l
	  * w pierwszym wierszu. Następnie sprawdza drzewo trie ze słowami o 
	  * długości h, aby ustalić, czy każdy początek kolumny jest początkiem
	  * słowa o długości h. Jeśli tak jest, należy rekurencyjnie sprawdzić
	  * słowa dla następnego wiersza; proces ten jest kontynuowany do czasu
	  * uzyskania kompletnego prostokąta. Po jego utworzeniu wystarczy sprawdzić,
	  * czy każda kolumna zawiera słowo ze słownika
	  */
	private Rectangle makePartialRectangle(int l, int h, Rectangle rectangle) {

		// Sprawdzanie, czy powstał kompletny prostokąt. Wymaga to ustalenia,
		// czy każda kolumna znajduje się w słowniku
		if (rectangle.height == h) {
			if (rectangle.isComplete(l, h, groupList[h - 1])) {
				return rectangle;
			} else {
				return null;
			}
		}

		// Jeśli prostokąt nie jest pusty, należy sprawdzić, czy każda kolumna
		// zawiera początek zapisanego w słowniku słowa o długości h. Przy
		// sprawdzaniu używane jest drzewo trie ze słowami o długości h
		if (!rectangle.isPartialOK(l, trieList[h - 1])) {
			return null;
		}
		
		// Dla każdego słowa o długości l należy spróbować utworzyć nowy
		// prostokąt przez dodanie tego słowa do istniejącego prostokąta
		for (int i = 0; i < groupList[l-1].length(); i++) {
			Rectangle orgPlus = rectangle.append(groupList[l-1].getWord(i));
			Rectangle rect = makePartialRectangle(l, h, orgPlus);
			if (rect != null) {
				return rect;
			}
		}
		return null;
	}

	// Test
	public static void main(String[] args) {
		Pytanie dict = new Pytanie(AssortedMethods.getListOfWords());
		Rectangle rect = dict.maxRectangle();
		if (rect != null) {
			rect.print();
		} else {
			System.out.println ("Prostokąt nie istnieje");
		}
	}


}

