// Program sprawdzający, czy serwomotory działają prawidłowo.
// Przyjęte jest założenie, że lewy serwomotor jest dołączony do pinu nr 9,
// a prawy do pinu nr 8.
//
// Uruchomienie:
// node examples/test_servos.js PORT
 
var five = require("johnny-five");
var temporal = require("temporal");

var opts = {};
opts.port = process.argv[2] || "";

var board = new five.Board(opts);

board.on("ready", function() {

    console.log("Program kontrolny sprawdzający, czy wszystko działa poprawnie.");
    console.log("Serwomotory powinny obracać się przez 3 s w przód, zatrzymać na 3 s, obracać wstecz przez 3 s i zatrzymać się.");

    var left_wheel  = new five.Servo({ pin:  9, type: 'continuous' });
    var right_wheel = new five.Servo({ pin: 8, type: 'continuous'  });

    temporal.queue([
        {
            delay: 5000,
            task: function() {
                console.log("W przód");
                left_wheel.cw();
                right_wheel.ccw();
            },
        },
        {
            delay: 3000,
            task: function() {
                console.log("Zatrzymanie");
                left_wheel.stop();
                right_wheel.stop();
            },
        },
        {        
            delay: 3000,
            task: function() {
                console.log("Wstecz");
                left_wheel.ccw();
                right_wheel.cw();
            },
        },
        {
            delay: 3000,
            task: function() {
                console.log("Zatrzymanie");
                left_wheel.stop();
                right_wheel.stop();
            },
        },
        {
            delay: 1500,
            task: function() {
                console.log("Koniec testu, wyjście");
                process.exit();
            },
        },
    ]);

});


