var express = require('express');
var router = express.Router();

// Wyczyszczenie jednej matrycy
router.post('/clear/:device', function(req,res) {
  var device = req.params.device;
  var matrices = req.app.get("matrices");
  if (matrices) {
    matrices.device(device).clear();
    res.send("Wyczyszczona matryca " + device);
  } else {
    res.status(500);
    res.send("Matryce nie są gotowe");
  }
});

// Wyczyszczenie wszystkich matryc
router.post('/clear', function(req,res) {
  var matrices = req.app.get("matrices");
  if (matrices) {
    matrices.clear();
    res.send("Wyczyszczone wszystkie matryce");
  } else {
    res.status(500);
    res.send("Matryce nie są gotowe");
  }
});

// Wyświetlenie wzoru na jednej matrycy
router.post('/draw/:device', function(req, res) {
  var device = req.params.device;
  var data = req.body;
  // Pobranie obiektu matrices z aplikacji express
  var matrices = req.app.get("matrices");
  if (matrices) {
    matrices.device(device).draw(data);
    res.send("Aktualizacja matrycy " + device);
  } else {
    res.status(500);
    res.send("Matryce nie są gotowe");
  }
});

module.exports = router;
