import {render, screen, waitFor} from "@testing-library/react";
import ShowDetails from "./ShowDetails";
import timekeeper from "./timekeeper";

let renders = [];
let tracker = (
    id,
    phase,
    actualDuration,
    baseDuration,
    startTime,
    commitTime,
    interactions
) => {
    renders.push({
        id,
        phase,
        actualDuration,
        baseDuration,
        startTime,
        commitTime,
        interactions
    })
};

const t = timekeeper();

describe('ShowDetails', () => {
    beforeEach(() => {
        renders = [];
        t.next();
    });
    afterEach(() => {
        console.log('Czas wykonania: ', t.next().value);
        console.table(renders);
    });
    it('powinien wyświetlić wolne wyniki w czasie około 20 sekund', async () => {
        render(<ShowDetails onRender={tracker}/>);
        await waitFor(() => {
            return expect(screen.getByText(/osoby - czas pobierania wolnego: 4/i)).toBeInTheDocument();
        }, {timeout: 30000});
    }, 30000);
    it('powinien wyświetlić szybkie wyniki w czasie około 5 sekund', async () => {
        render(<ShowDetails onRender={tracker}/>);
        await waitFor(() => {
            return expect(screen.getByText(/osoby - czas pobierania szybkiego: 4/i)).toBeInTheDocument();
        }, {timeout: 5000});
    }, 30000);
    //*/
});