import {render, screen, waitFor} from '@testing-library/react';
import user from '@testing-library/user-event';
import App from './App';
const sinon = require('sinon');

function makeRandomAlways(result) {
  if (Math.random.restore) {
    Math.random.restore();
  }
  sinon.stub(Math, 'random').returns(result);
}

describe('Komponent App', () => {
  it('powinien powiedzieć graczowi, kiedy wygrał', async () => {
    // Przy założeniu, że aplikacja została wyrenderowana,
    render(<App/>);

    // kiedy użytkownik poda poprawną odpowiedź,
    const number1 = screen.getByTestId('number1').textContent;
    const number2 = screen.getByTestId('number2').textContent;
    const input = screen.getByLabelText(/odpowiedź:/i);
    const submitButton = screen.getByText('Prześlij');
    user.type(input, '' + (parseFloat(number1) * parseFloat(number2)));
    user.click(submitButton);

    // aplikacja ma wyświetlić komunikat, że użytkownik wygrał
    // screen.getByText(/wygrałeś/i);
    await waitFor(() => screen.findByText(/wygrałeś/i), {timeout: 4000});
  })

  
  it('powinien wyłączyć pytanie po wyświetleniu wyniku', () => {
    render(<App/>);
    const input = screen.getByLabelText(/odpowiedź:/i);
    user.type(input, '1');
    const submitButton = screen.getByText('Prześlij');
    user.click(submitButton);
    expect(input.disabled).toBe(true);
    expect(submitButton.disabled).toBe(true);
    expect(screen.getByLabelText(/odpowiedź:/i)).toHaveValue(null);
  })

  it('powinien ponownie rozpocząć grę po kliknięciu Zagraj jeszcze raz', () => {
    render(<App/>);
    const input = screen.getByLabelText(/odpowiedź:/i);
    user.type(input, '1');
    const submitButton = screen.getByText('Prześlij');
    user.click(submitButton);
    expect(input.disabled).toBe(true);
    expect(submitButton.disabled).toBe(true);
    const refreshButton = screen.getByText('Zagraj jeszcze raz');
    user.click(refreshButton);
    expect(submitButton.disabled).toBe(false);
    expect(screen.getByLabelText(/odpowiedź:/i)).toHaveValue(null);
    expect(input.disabled).toBe(false);
  })
  
  
  it('powinien poinformować o podaniu prawidłowej odpowiedzi', async () => {
    // Przy założeniu, że uruchomiłem aplikację
    makeRandomAlways(0.5);
    render(<App/>);

    // kiedy wpiszę niepoprawną odpowiedź,
    const input = screen.getByLabelText(/odpowiedź:/i);
    const submitButton = screen.getByText('Prześlij');
    user.type(input, '36');
    user.click(submitButton);

    // serwer zostanie poinformowany o tym, że przegrałem
    await waitFor(() => screen.findByText(/wygrałeś/i), {timeout: 4000});
  })
});
