import { useState } from 'react'
import Logout from './Logout'
import axios from 'axios'
import { create } from '@github/webauthn-json'

const Private2 = () => {
  const [busy, setBusy] = useState(false)
  const [message, setMessage] = useState()

  const registerToken = async (startRegistrationEndpoint) => {
    setBusy(true)
    try {
      const response = await axios.post(startRegistrationEndpoint)
      setMessage('Wysyłanie żądania')
      const attestation = await create({ publicKey: response.data })
      setMessage('Utworzenie atestacji')
      const attestationResponse = await axios.post('/register', {
        attestation,
      })
      setMessage('Zarejestrowano nowy klucz')
      if (
        attestationResponse.data &&
        attestationResponse.data.verified
      ) {
        alert('Nowy klucz został zarejestrowany')
      }
    } catch (err) {
      setMessage('' + err)
    } finally {
      setBusy(false)
    }
  }
  return (
    <div className="Private2">
      <h1>Konto użytkownika</h1>

      {window.PublicKeyCredential && (
        <>
          <p>Zarejestruj nowy klucz sprzętowy</p>
          <button
            onClick={() => registerToken('/startRegister')}
            disabled={busy}
          >
            Włącz logowanie przy użyciu klucza sprzętowego
          </button>
          <button
            onClick={() => registerToken('/startFingerprint')}
            disabled={busy}
          >
            Włącz logowanie przy użyciu czytnika linii papilarnych
          </button>
        </>
      )}
      <div className="Account-message">{message}</div>

      <Logout />
    </div>
  )
}

export default Private2
