import {render, screen} from '@testing-library/react';
import user from '@testing-library/user-event';
import Question from "./Question";
import {Podstawowy, ZDisabled} from './Question.stories'

const sinon = require('sinon');

const stories = require('./Question.stories');

describe('Komponent Question', () => {

  it('powinien bez błędów wyrenderować wszystkie opowieści Storybook', () => {
    for (let story in stories) {
      if (story !== 'default') {
        let C = stories[story];
        render(<C/>);
      }
    }
  });

  
  it('powinien dezaktywować przycisk, gdy zostanie o to poproszony', () => {
    render(<ZDisabled />);
    const refreshButton = screen.getByRole('button');
    expect(refreshButton.disabled).toEqual(true);
  });
  

  it('powinien wywołać onAnswer przekazując wartość początkową i zaktualizować ją, gdy zostanie o to poproszony', () => {
    const callback = sinon.fake();
    render(<Question onAnswer={callback}/>);
    const number1Before = screen.getByTestId('number1').textContent;
    const number2Before = screen.getByTestId('number2').textContent;
    sinon.assert.calledWith(callback, parseFloat(number1Before) * parseFloat(number2Before))
    expect(callback.callCount).toEqual(1);
    const refreshButton = screen.getByRole('button');
    user.click(refreshButton);
    const number1After = screen.getByTestId('number1').textContent;
    const number2After = screen.getByTestId('number2').textContent;
    sinon.assert.calledWith(callback, parseFloat(number1After) * parseFloat(number2After))
  });
});
