import './App.css'
import {
  Admin,
  Create,
  Datagrid,
  Filter,
  List,
  Resource,
  SimpleForm,
  TextField,
  TextInput,
} from 'react-admin'
import buildGraphQLProvider from 'ra-data-graphql-simple'
import { useEffect, useState } from 'react'

import polishMessages from 'ra-language-polish';

const messages = {
  'pl': polishMessages,
};

const CreateMessage = (props) => {
  return (
    <Create title="Utwórz wiadomość" {...props}>
      <SimpleForm>
        <TextInput source="author" label={"Autor"} />
        <TextInput multiline source="text" label={"Tekst wiadomości"} />
      </SimpleForm>
    </Create>
  )
}

const MessageFilter = (props) => (
  <Filter {...props}>
    <TextInput label="Autor" source="author" />
    <TextInput label="Tekst" source="text" />
    <TextInput label="Szukaj" source="q" alwaysOn />
  </Filter>
)

const ListMessages = (props) => {
  return (
    <List {...props} title={"Wiadomości"} filters={<MessageFilter />}>
      <Datagrid>
        <TextField source="id" />
        <TextField source="author" label="Autor" />
        <TextField source="text" label="Tekst" />
      </Datagrid>
    </List>
  )
}

function App() {
  const [dataProvider, setDataProvider] = useState()

  useEffect(() => {
    ;(async () => {
      const dp = await buildGraphQLProvider({
        clientOptions: { uri: 'http://localhost:5000' },
      })
      setDataProvider(() => dp)
    })()
  }, [])

  return (
    <div className="App">
      {dataProvider && (
        <Admin dataProvider={dataProvider}>
          <Resource
            name="Message"
            list={ListMessages}
            create={CreateMessage}
          />
        </Admin>
      )}
    </div>
  )
}

export default App
