import { useEffect } from 'react'

const useKeyListener = (callback) => {
  useEffect(() => {
    const listener = (e) => {
      e = e || window.event
      const tagName = e.target.localName || e.target.tagName
      // Aby uniknąć przechwytywania takich zdarzeń jak naciśnięcia klawiszy
      // w polach tekstowych, akceptuje jedynie zdarzenia klawiatury wygenerowane 
      // na poziomie globalnym.
      if (tagName.toUpperCase() === 'BODY') {
        callback(e)
      }
    }
    document.addEventListener('keydown', listener, true)
    return () => {
      document.removeEventListener('keydown', listener, true)
    }
  }, [callback])
}

export default useKeyListener
