import { useDispatch, useSelector } from 'react-redux'

import './Basket.css'
import summarizer from './summarizer'
import taxer from './taxer'

const Basket = () => {
  const basket = useSelector((state) => state.basket)
  const { itemCount, cost } = useSelector(summarizer)
  const tax = useSelector(taxer)
  const dispatch = useDispatch()

  return (
    <div className="Basket">
      <h2>Koszyk</h2>
      {basket && basket.length ? (
        <>
          {basket.map((item) => (
            <div className="Basket-item">
              <div className="Basket-itemName">{item.name}</div>
              <div className="Basket-itemProductId">
                {item.productId}
              </div>
              <div className="Basket-itemPricing">
                <div className="Basket-itemQuantity">
                  {item.quantity}
                </div>
                <div className="Basket-itemPrice">{item.price.toLocaleString("pl-PL")} zł</div>
              </div>
            </div>
          ))}
          <p>Liczba produktów w koszyku: {itemCount}</p>
          <p>Wartość całkowita: {cost.toLocaleString("pl-PL", {style: 'currency', currency:'pln'})}</p>
          <p>Kwota podatku: {tax.toLocaleString("pl-PL", {style: 'currency', currency:'pln'})}</p>
          <button onClick={() => dispatch({ type: 'clearBasket' })}>
            Wyczyść
          </button>
        </>
      ) : (
        'Koszyk jest pusty'
      )}
    </div>
  )
}

export default Basket
