import useErrorHandler from './useErrorHandler'
import axios from 'axios'

export default () => {
  const setVisibleError = useErrorHandler()

  const doClockIn = async () => {
    try {
      await axios.put('/clockTime')
    } catch (err) {
      setVisibleError('Nie można zarejestrować czasu rozpoczęcia pracy', err)
    }
  }

  return (
    <>
      <h1>Kliknij przycis, by zarejestrować czas rozpoczęcia pracy</h1>
      <button onClick={doClockIn}>Zaczynamy pracę</button>
    </>
  )
}
