import { useState } from 'react'
import Logout from './Logout'
import axios from 'axios'
import { create } from '@github/webauthn-json'

const Private2 = () => {
  const [busy, setBusy] = useState(false)
  const [message, setMessage] = useState()

  return (
    <div className="Private2">
      <h1>Konto użytkownika</h1>

      {window.PublicKeyCredential && (
        <>
          <p>Zarejestruj nowy klucz sprzętowy</p>
          <button
            onClick={async () => {
              setBusy(true)
              try {
                const response = await axios.post('/startRegister')
                setMessage('Wysyłanie żądania')
                const attestation = await create({
                  publicKey: response.data,
                })
                setMessage('Utworzenie atestacji')
                const attestationResponse = await axios.post(
                  '/register',
                  {
                    attestation,
                  }
                )
                setMessage('Zarejestrowano!')
                if (
                  attestationResponse.data &&
                  attestationResponse.data.verified
                ) {
                  alert('Zarejestrowano nowy klucz')
                }
              } catch (err) {
                setMessage('' + err)
              } finally {
                setBusy(false)
              }
            }}
            disabled={busy}
          >
            Zarejestruj
          </button>
        </>
      )}
      <div className="Account-message">{message}</div>

      <Logout />
    </div>
  )
}

export default Private2
