import useErrorHandler from './useErrorHandler'
import axios from 'axios'

const ClockIn = () => {
  const setVisibleError = useErrorHandler()

  const doClockIn = async () => {
    try {
      await axios.put('/clockTime')
    } catch (err) {
      setVisibleError('Nie udało się zarejestrować czasu rozpoczęcia pracy', err)
    }
  }

  return (
    <>
      <h1>Kliknij przycisk, by rozpocząć pomiar czasu pracy</h1>
      <button onClick={doClockIn}>Zaczynam robotę!</button>
    </>
  )
}

export default ClockIn
