import taxer from './taxer'

describe('funkcja taxer', () => { 
  it('powinna zwracać 0 jeśli koszyk jest pusty', () => {
    const actual = taxer({ basket: [] })
    expect(actual).toEqual(0.0)
  })
  it('powinna mnożyć cenę produktu przez ilość egzemplarzy', () => {
    const actual = taxer({
      basket: [{ productId: '1234', quantity: 2, price: 1.23 }],
    })
    expect(actual).toBeCloseTo(0.5412, 6)
  })
  it('powinna obsługiwać wiele produktów', () => {
    const actual = taxer({
      basket: [
        { productId: '1234', quantity: 2, price: 1.23 },
        { productId: '5678', quantity: 1, price: 1.5 },
      ],
    })
    expect(actual).toBeCloseTo(0.8712, 6)
  })
})
