import React, { Component } from "react";

import { StyleSheet, Text, View, Image, FlatList } from "react-native";

import Ksiazka from "./Ksiazka";
import NYT from "./NYT";

export default class ListaKsiazek extends Component {
    constructor(props) {
        super(props);
        this.state = { dane: [] };
    }

    componentDidMount() {
        this._odswiezDane();
    }

    _renderujElement = ({ item }) => {
        return (
            <Ksiazka
                okladkaURL={item.book_image}
                tytul={item.key}
                autor={item.author}
            />
        );
    };

    _dodajKluczeDoKsiazek = ksiazki => {
        // Odbiera odpowiedź z API NYTimes i dodaje klucz do obiektu do celów renderowania
        return ksiazki.map(ksiazka => {
            return Object.assign(ksiazka, { key: ksiazka.title });
        });
    };

    _odswiezDane = () => {
        NYT.pobierzKsiazki().then(ksiazki => {
            this.setState({ dane: this._dodajKluczeDoKsiazek(ksiazki) });
        });
    };

    render() {
        return (
            <View style={styles.kontener}>
                <FlatList data={this.state.dane} renderItem={this._renderujElement} />
            </View>
        );
    }
}

const styles = StyleSheet.create({ kontener: { flex: 1, paddingTop: 22 } });
