import React, { Component } from "react";

import { StyleSheet, Text, View, TextInput } from "react-native";
import MapaPogody from "./open_weather_map";
import Prognoza from "./Prognoza";

export default class ProjektPogodynka extends Component<{}> {
  constructor(props) {
    super(props);
    this.state = { kod: "", prognoza: null };
  }

  _handleTextChange = event => {
      let kod = event.nativeEvent.text;
      MapaPogody.pobierzPrognoze(kod).then(prognoza => {
		console.log(prognoza);  
        this.setState({ prognoza: prognoza });
      });
	  this.setState({ kod: event.nativeEvent.text });
  };

  render() {
	let tresc = null;
    if (this.state.prognoza !== null) {
      tresc = (
        <Prognoza
          glowne={this.state.prognoza.glowne}
          opis={this.state.prognoza.opis}
          temp={this.state.prognoza.temp}
        />
      );
    }
	  
    return (
      <View style={styles.kontener}>
        <Text style={styles.witaj}>
          Wpisałeś {this.state.kod}.
        </Text>
		{tresc}
        <TextInput
          style={styles.wejscie}
          onSubmitEditing={this._handleTextChange}
        />
      </View>
    );
  }
}

const styles = StyleSheet.create({
  kontener: {
    flex: 1,
    justifyContent: "center",
    alignItems: "center",
    backgroundColor: "#666666"
  },
  witaj: { fontSize: 20, textAlign: "center", margin: 10 },
  wejscie: {
    fontSize: 20,
    borderWidth: 2,
    padding: 2,
    height: 40,
    width: 100,
    textAlign: "center"
  }
});
