import React, { Component } from "react";
import {
  StyleSheet,
  Text,
  View,
  TextInput,
  AsyncStorage,
  Image
} from "react-native";

import Prognoza from "./Prognoza";
import PrzyciskLokalizacji from "./PrzyciskLokalizacji";
import styleTekstu from "./styles/typografia.js";

const KLUCZ_MAGAZYNU = "@LepszaPogodynka:kod";

import MapaPogody from "./open_weather_map";

// Ta wersja korzysta z pliku kwiaty.png z lokalnych zasobów
import FotoTlo from "./FotoTlo/lokalny_obraz";

// Ta wersja pobiera obraz wybrany z galerii aparatu
//import FotoTlo from './FotoTlo';

class ProjektPogodynka extends Component {
  constructor(props) {
    super(props);
    this.state = { prognoza: null };
  }

  componentDidMount() {
    AsyncStorage
      .getItem(KLUCZ_MAGAZYNU)
      .then(wartosc => {
        if (wartosc !== null) {
          this._pobierzPrognozeDlaKodu(wartosc);
        }
      })
      .catch(error => console.error("Błąd AsyncStorage: " + error.message))
      .done();
  }

  _pobierzPrognozeDlaKodu = kod => {
    // Zapisz kod pocztowy
    AsyncStorage
      .setItem(KLUCZ_MAGAZYNU, kod)
      .then(() => console.log("Zapisano na dysku: " + kod))
      .catch(error => console.error("Błąd AsyncStorage: " + error.message))
      .done();

    MapaPogody.pobierzPrognozeKod(kod).then(prognoza => {
      this.setState({ prognoza: prognoza });
    });
  };

  _pobierzPrognozeDlaWspolrzednych = (lat, lon) => {
    MapaPogody.pobierzPrognozeWspolrzedne(lat, lon).then(prognoza => {
      this.setState({ prognoza: prognoza });
    });
  };

  _zmianaTekstu = event => {
    let kod = event.nativeEvent.text;
    this._pobierzPrognozeDlaKodu(kod);
  };

  render() {
    let tresc = null;
    if (this.state.prognoza !== null) {
      tresc = (
        <View style={styles.wiersz}>
          <Prognoza
            glowny={this.state.prognoza.glowny}
            temp={this.state.prognoza.temp}
          />
        </View>
      );
    }

    return (
      <FotoTlo>
        <View style={styles.nakladka}>
          <View style={styles.wiersz}>
            <Text style={styleTekstu.glownyTekst}>
              Prognoza dla
            </Text>

            <View style={styles.kontenerKodu}>
              <TextInput
                style={[styleTekstu.glownyTekst, styles.kodPocztowy]}
                onSubmitEditing={this._zmianaTekstu}
                underlineColorAndroid="transparent"
              />
            </View>
          </View>

          <View style={styles.wiersz}>
            <PrzyciskLokalizacji onGetCoords={this._pobierzPrognozeDlaWspolrzednych} />
          </View>

          {tresc}

        </View>
      </FotoTlo>
    );
  }
}

const styles = StyleSheet.create({
  nakladka: { backgroundColor: "rgba(0,0,0,0.1)" },
  wiersz: {
    flexDirection: "row",
    flexWrap: "nowrap",
    alignItems: "center",
    justifyContent: "center",
    padding: 24
  },
  kontenerKodu: {
    borderBottomColor: "#DDDDDD",
    borderBottomWidth: 1,
    marginLeft: 5,
    marginTop: 3,
    width: 80,
    height: styleTekstu.podstawowyRozmiarCzcionki * 2,
    justifyContent: "flex-end"
  },
  kodPocztowy: { flex: 1 }
});

export default ProjektPogodynka;
