import React, {Component} from "react";
import {StackNavigator} from "react-navigation";
import {createStore} from "redux";
import {Provider} from "react-redux";
import {reduktor} from "../reduktory";

import Logo from "./Naglowek/Logo";
import EkranTalii from "./EkranTalii";
import EkranNowejKarty from "./EkranNowejKarty";
import EkranPowtorki from "./EkranPowtorki";

let magazyn = createStore(reduktor);
let opcjeNaglowka = {
    headerStyle: {backgroundColor: "#FFFFFF"},
    headerLeft: <Logo/>
};

const Nawigator = StackNavigator({
    EkranGlowny: {screen: EkranTalii, navigationOptions: opcjeNaglowka},
    Powtorka: {screen: EkranPowtorki, navigationOptions: opcjeNaglowka},
    StworzNowaKarte: {screen: EkranNowejKarty, path: "StworzNowaKarte/:idTalii", navigationOptions: opcjeNaglowka}
});

export default class App extends Component {
    render() {
        return (
            <Provider store={magazyn}>
                <Nawigator/>
            </Provider>
        );
    }
}
