import React, {Component} from "react";
import {StyleSheet, View} from "react-native";

import PodgladKart from "./PodgladKart";
import {MakietaPowtorki} from "../../dane/Makiety";
import {utworzPodsumowanie} from "./PodsumowaniePowtorki";
import colors from "../../style/kolory";

class EkranPowtorki extends Component {
    static displayName = "EkranPowtorki";
    static navigationOptions = {title: "Powtorka"};

    constructor(props) {
        super(props);
        this.state = {
            iloscPrzejrzanych: 0,
            iloscPoprawnych: 0,
            obecnaPowtorka: 0,
            powtorka: MakietaPowtorki
        };
    }

    naAkcje = poprawnosc => {
        if (poprawnosc) {
            this.setState({iloscPoprawnych: this.state.iloscPoprawnych + 1});
        }
        this.setState({iloscPrzejrzanych: this.state.iloscPrzejrzanych + 1});
    };

    nastepnaDoPowtorki = () => {
        console.warn("Pokazuje następną powtorkę, ale nie zostało zaimplementowane zapisywanie danych");
        this.setState({obecnaPowtorka: this.state.obecnaPowtorka + 1});
    };

    wyjdzZPowtorki = () => {
        console.warn("Zapisywanie danych nie zaimplementowane");
        this.props.navigation.goBack();
    };

    zawartosc() {
        if (!this.state.powtorka || this.state.powtorka.length === 0) {
            return null;
        }

        if (this.state.obecnaPowtorka < this.state.powtorka.length) {
            return (
                <PodgladKart
                    naAkcje={this.naAkcje}
                    kontynuuj={this.nastepnaDoPowtorki}
                    wyjdz={this.wyjdzZPowtorki}
                    {...this.state.powtorka[this.state.obecnaPowtorka]}
                />
            );
        } else {
            let procenty = this.state.iloscPoprawnych / this.state.iloscPrzejrzanych;
            return utworzPodsumowanie(procenty, this.wyjdzZPowtorki);
        }
    }

    render() {
        return (
            <View style={styles.kontener}>
                {this.zawartosc()}
            </View>
        );
    }
}

const styles = StyleSheet.create({
    kontener: {backgroundColor: colors.blue, flex: 1, paddingTop: 24}
});

export default EkranPowtorki;
