import React, { Component } from 'react';
import {
    Platform,
    StyleSheet,
    Text,
    TouchableHighlight,
    View
} from 'react-native';

export default class Button extends Component {
    constructor(props) {
        super(props);
        this.state = { pressing: false };
    }

    _onPressIn = () => {
        this.setState({ pressing: true });
    };

    _onPressOut = () => {
        this.setState({ pressing: false });
    };

    render() {
        return (
            <View style={styles.kontener}>
                <TouchableHighlight
                    onPressIn={this._onPressIn}
                    onPressOut={this._onPressOut}
                    style={styles.dotyk}
                >

                    <View style={styles.przycisk}>
                        <Text style={styles.witaj}>
                            {this.state.pressing ? "IIK!" : "NACIŚNIJ MNIE"}
                        </Text>
                    </View>

                </TouchableHighlight>
            </View>
        );
    }
}

const styles = StyleSheet.create({
    kontener: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "#F5FCFF"
    },
    witaj: { fontSize: 20, textAlign: "center", margin: 10, color: "#FFFFFF" },
    dotyk: { borderRadius: 100 },
    przycisk: {
        backgroundColor: "#FF0000",
        borderRadius: 100,
        height: 200,
        width: 200,
        justifyContent: "center"
    }
});
