import React, { Component } from "react";
import { StyleSheet, View } from "react-native";

import Button from "./../Button";
import NormalnyTekst from "./../NormalnyTekst";
import TekstNaglowka from "./../TekstNaglowka";
import colors from "../../style/kolory";

class PrzyciskKontynuacji extends Component {
  render() {
    let tekst = this.props.byloPoprawne
      ? "Gratulacje! Następna karta?"
      : "Oj, coś poszło nie tak. Następna karta?";
    return (
      <Button naNacisniecie={this.props.naNacisniecie} style={styles.przyciskKontynuacji}>
        <NormalnyTekst>{tekst}</NormalnyTekst>
      </Button>
    );
  }
}

function utworzPrzyciskiKontynuacjiIWyjscia(
  czyPokazacOdpowiedz,
  czyOdpowiedzBylaPoprawna,
  kontynuuj,
  funkcjaWyjscia
) {
  if (czyPokazacOdpowiedz) {
    return <PrzyciskKontynuacji naNacisniecie={kontynuuj} byloPoprawne={czyOdpowiedzBylaPoprawna} />;
  } else {
    return (
      <Button naNacisniecie={funkcjaWyjscia} style={styles.przyciskKontynuacji}>
        <NormalnyTekst>Zakoncz powtorke</NormalnyTekst>
      </Button>
    );
  }
}

function utworzPrzyciskiOdpowiedzi(
  odpowiedz,
  poprawnaOdpowiedz,
  pokazacOdpowiedz,
  byloPoprawnie,
  wybierzPoprawnaOdpowiedz
) {
  if (!odpowiedz) return null;

  return odpowiedz.map(a => {
    let bylaPoprawnaOdpowiedz = a === poprawnaOdpowiedz;
    let stylePrzycisku = [styles.opcje];
    if (pokazacOdpowiedz && bylaPoprawnaOdpowiedz) {
      if (byloPoprawnie) {
        stylePrzycisku.push(styles.poprawnaOdpowiedz);
      } else {
        stylePrzycisku.push(styles.zlaOdpowiedz);
      }
    }

    return (
      <Button
          key={a}
          zablokowany={pokazacOdpowiedz}
          style={stylePrzycisku}
          naNacisniecie={() => {
          wybierzPoprawnaOdpowiedz(bylaPoprawnaOdpowiedz);
        }}
      >
        <NormalnyTekst>
          {a}
        </NormalnyTekst>
      </Button>
    );
  });
}

const styles = StyleSheet.create({
  opcje: { backgroundColor: "#FFFFFF" },
  przyciskKontynuacji: { backgroundColor: colors.tan },
  poprawnaOdpowiedz: { backgroundColor: colors.green },
  zlaOdpowiedz: { backgroundColor: colors.pink }
});

export { utworzPrzyciskiKontynuacjiIWyjscia, utworzPrzyciskiOdpowiedzi };
