/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.storage.AsyncLocalStorageUtil;
import com.facebook.react.modules.storage.AsyncStorageErrorUtil;
import com.facebook.react.modules.storage.ReactDatabaseSupplier;
import java.util.HashSet;

@ReactModule(name="AsyncSQLiteDBStorage")
public final class AsyncStorageModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable {
    protected static final String NAME = "AsyncSQLiteDBStorage";
    private static final int MAX_SQL_KEYS = 999;
    private ReactDatabaseSupplier mReactDatabaseSupplier;
    private boolean mShuttingDown = false;

    public AsyncStorageModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mReactDatabaseSupplier = ReactDatabaseSupplier.getInstance((Context)reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mShuttingDown = false;
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
    }

    @Override
    public void clearSensitiveData() {
        this.mReactDatabaseSupplier.clearAndCloseDatabase();
    }

    @ReactMethod
    public void multiGet(final ReadableArray keys, final Callback callback) {
        if (keys == null) {
            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null), null);
            return;
        }
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null), null);
                    return;
                }
                String[] columns = new String[]{"key", "value"};
                HashSet<String> keysRemaining = new HashSet<String>();
                WritableArray data = Arguments.createArray();
                for (int keyStart = 0; keyStart < keys.size(); keyStart += 999) {
                    int keyCount = Math.min(keys.size() - keyStart, 999);
                    keysRemaining.clear();
                    try (Cursor cursor = AsyncStorageModule.this.mReactDatabaseSupplier.get().query("catalystLocalStorage", columns, AsyncLocalStorageUtil.buildKeySelection(keyCount), AsyncLocalStorageUtil.buildKeySelectionArgs(keys, keyStart, keyCount), null, null, null);){
                        if (cursor.getCount() != keys.size()) {
                            for (int keyIndex = keyStart; keyIndex < keyStart + keyCount; ++keyIndex) {
                                keysRemaining.add(keys.getString(keyIndex));
                            }
                        }
                        if (cursor.moveToFirst()) {
                            do {
                                WritableArray row = Arguments.createArray();
                                row.pushString(cursor.getString(0));
                                row.pushString(cursor.getString(1));
                                data.pushArray(row);
                                keysRemaining.remove(cursor.getString(0));
                            } while (cursor.moveToNext());
                        }
                    }
                    for (String key : keysRemaining) {
                        WritableArray row = Arguments.createArray();
                        row.pushString(key);
                        row.pushNull();
                        data.pushArray(row);
                    }
                    keysRemaining.clear();
                }
                callback.invoke(null, data);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void multiSet(final ReadableArray keyValueArray, final Callback callback) {
        if (keyValueArray.size() == 0) {
            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null));
            return;
        }
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                String sql = "INSERT OR REPLACE INTO catalystLocalStorage VALUES (?, ?);";
                SQLiteStatement statement = AsyncStorageModule.this.mReactDatabaseSupplier.get().compileStatement(sql);
                WritableMap error = null;
                try {
                    AsyncStorageModule.this.mReactDatabaseSupplier.get().beginTransaction();
                    for (int idx = 0; idx < keyValueArray.size(); ++idx) {
                        if (keyValueArray.getArray(idx).size() != 2) {
                            error = AsyncStorageErrorUtil.getInvalidValueError(null);
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(0) == null) {
                            error = AsyncStorageErrorUtil.getInvalidKeyError(null);
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(1) == null) {
                            error = AsyncStorageErrorUtil.getInvalidValueError(null);
                            return;
                        }
                        statement.clearBindings();
                        statement.bindString(1, keyValueArray.getArray(idx).getString(0));
                        statement.bindString(2, keyValueArray.getArray(idx).getString(1));
                        statement.execute();
                    }
                    AsyncStorageModule.this.mReactDatabaseSupplier.get().setTransactionSuccessful();
                }
                catch (Exception e) {
                    FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                    error = AsyncStorageErrorUtil.getError(null, e.getMessage());
                }
                finally {
                    block28: {
                        try {
                            AsyncStorageModule.this.mReactDatabaseSupplier.get().endTransaction();
                        }
                        catch (Exception e) {
                            FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                            if (error != null) break block28;
                            error = AsyncStorageErrorUtil.getError(null, e.getMessage());
                        }
                    }
                }
                if (error != null) {
                    callback.invoke(error);
                } else {
                    callback.invoke(new Object[0]);
                }
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void multiRemove(final ReadableArray keys, final Callback callback) {
        if (keys.size() == 0) {
            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null));
            return;
        }
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                WritableMap error = null;
                try {
                    AsyncStorageModule.this.mReactDatabaseSupplier.get().beginTransaction();
                    for (int keyStart = 0; keyStart < keys.size(); keyStart += 999) {
                        int keyCount = Math.min(keys.size() - keyStart, 999);
                        AsyncStorageModule.this.mReactDatabaseSupplier.get().delete("catalystLocalStorage", AsyncLocalStorageUtil.buildKeySelection(keyCount), AsyncLocalStorageUtil.buildKeySelectionArgs(keys, keyStart, keyCount));
                    }
                    AsyncStorageModule.this.mReactDatabaseSupplier.get().setTransactionSuccessful();
                }
                catch (Exception e) {
                    FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                    error = AsyncStorageErrorUtil.getError(null, e.getMessage());
                }
                finally {
                    block16: {
                        try {
                            AsyncStorageModule.this.mReactDatabaseSupplier.get().endTransaction();
                        }
                        catch (Exception e) {
                            FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                            if (error != null) break block16;
                            error = AsyncStorageErrorUtil.getError(null, e.getMessage());
                        }
                    }
                }
                if (error != null) {
                    callback.invoke(error);
                } else {
                    callback.invoke(new Object[0]);
                }
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void multiMerge(final ReadableArray keyValueArray, final Callback callback) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                WritableMap error = null;
                try {
                    AsyncStorageModule.this.mReactDatabaseSupplier.get().beginTransaction();
                    for (int idx = 0; idx < keyValueArray.size(); ++idx) {
                        if (keyValueArray.getArray(idx).size() != 2) {
                            error = AsyncStorageErrorUtil.getInvalidValueError(null);
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(0) == null) {
                            error = AsyncStorageErrorUtil.getInvalidKeyError(null);
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(1) == null) {
                            error = AsyncStorageErrorUtil.getInvalidValueError(null);
                            return;
                        }
                        if (AsyncLocalStorageUtil.mergeImpl(AsyncStorageModule.this.mReactDatabaseSupplier.get(), keyValueArray.getArray(idx).getString(0), keyValueArray.getArray(idx).getString(1))) continue;
                        error = AsyncStorageErrorUtil.getDBError(null);
                        return;
                    }
                    AsyncStorageModule.this.mReactDatabaseSupplier.get().setTransactionSuccessful();
                }
                catch (Exception e) {
                    FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                    error = AsyncStorageErrorUtil.getError(null, e.getMessage());
                }
                finally {
                    block31: {
                        try {
                            AsyncStorageModule.this.mReactDatabaseSupplier.get().endTransaction();
                        }
                        catch (Exception e) {
                            FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                            if (error != null) break block31;
                            error = AsyncStorageErrorUtil.getError(null, e.getMessage());
                        }
                    }
                }
                if (error != null) {
                    callback.invoke(error);
                } else {
                    callback.invoke(new Object[0]);
                }
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void clear(final Callback callback) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.mReactDatabaseSupplier.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                try {
                    AsyncStorageModule.this.mReactDatabaseSupplier.clear();
                    callback.invoke(new Object[0]);
                }
                catch (Exception e) {
                    FLog.w((String)"ReactNative", (String)e.getMessage(), (Throwable)e);
                    callback.invoke(AsyncStorageErrorUtil.getError(null, e.getMessage()));
                }
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void getAllKeys(final Callback callback) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null), null);
                    return;
                }
                WritableArray data = Arguments.createArray();
                String[] columns = new String[]{"key"};
                try (Cursor cursor = AsyncStorageModule.this.mReactDatabaseSupplier.get().query("catalystLocalStorage", columns, null, null, null, null, null);){
                    if (cursor.moveToFirst()) {
                        do {
                            data.pushString(cursor.getString(0));
                        } while (cursor.moveToNext());
                    }
                }
                callback.invoke(null, data);
            }
        }.execute(new Void[0]);
    }

    private boolean ensureDatabase() {
        return !this.mShuttingDown && this.mReactDatabaseSupplier.ensureDatabase();
    }
}

