/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.deviceinfo;

import android.content.Context;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="DeviceInfo")
public class DeviceInfoModule
extends BaseJavaModule
implements LifecycleEventListener {
    @Nullable
    private ReactApplicationContext mReactApplicationContext = null;
    private float mFontScale;

    public DeviceInfoModule(ReactApplicationContext reactContext) {
        this((Context)reactContext);
        this.mReactApplicationContext = reactContext;
        this.mReactApplicationContext.addLifecycleEventListener(this);
    }

    public DeviceInfoModule(Context context) {
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(context);
        this.mFontScale = context.getResources().getConfiguration().fontScale;
    }

    @Override
    public String getName() {
        return "DeviceInfo";
    }

    @Override
    @Nullable
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("Dimensions", DisplayMetricsHolder.getDisplayMetricsMap(this.mFontScale));
        return constants;
    }

    @Override
    public void onHostResume() {
        if (this.mReactApplicationContext == null) {
            return;
        }
        float fontScale = this.mReactApplicationContext.getResources().getConfiguration().fontScale;
        if (this.mFontScale != fontScale) {
            this.mFontScale = fontScale;
            this.emitUpdateDimensionsEvent();
        }
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
    }

    public void emitUpdateDimensionsEvent() {
        if (this.mReactApplicationContext == null) {
            return;
        }
        this.mReactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("didUpdateDimensions", DisplayMetricsHolder.getDisplayMetricsMap(this.mFontScale));
    }
}

