/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.Context;
import android.net.Uri;
import android.text.SpannableStringBuilder;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.flat.FlatTextShadowNode;
import com.facebook.react.flat.InlineImageSpanWithPipeline;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.imagehelper.ImageSource;
import javax.annotation.Nullable;

class RCTTextInlineImage
extends FlatTextShadowNode {
    private InlineImageSpanWithPipeline mInlineImageSpan = new InlineImageSpanWithPipeline();

    RCTTextInlineImage() {
    }

    @Override
    public void setStyleWidth(float width) {
        super.setStyleWidth(width);
        if (this.mInlineImageSpan.getWidth() != width) {
            this.getMutableSpan().setWidth(width);
            this.notifyChanged(true);
        }
    }

    @Override
    public void setStyleHeight(float height) {
        super.setStyleHeight(height);
        if (this.mInlineImageSpan.getHeight() != height) {
            this.getMutableSpan().setHeight(height);
            this.notifyChanged(true);
        }
    }

    @Override
    protected void performCollectText(SpannableStringBuilder builder) {
        builder.append((CharSequence)"I");
    }

    @Override
    protected void performApplySpans(SpannableStringBuilder builder, int begin, int end, boolean isEditable) {
        this.mInlineImageSpan.freeze();
        builder.setSpan((Object)this.mInlineImageSpan, begin, end, 17);
    }

    @Override
    protected void performCollectAttachDetachListeners(StateBuilder stateBuilder) {
        stateBuilder.addAttachDetachListener(this.mInlineImageSpan);
    }

    @ReactProp(name="src")
    public void setSource(@Nullable ReadableArray sources) {
        String source = sources == null || sources.size() == 0 ? null : sources.getMap(0).getString("uri");
        ImageSource imageSource = source == null ? null : new ImageSource((Context)this.getThemedContext(), source);
        this.getMutableSpan().setImageRequest(imageSource == null ? null : ImageRequestBuilder.newBuilderWithSource((Uri)imageSource.getUri()).build());
    }

    private InlineImageSpanWithPipeline getMutableSpan() {
        if (this.mInlineImageSpan.isFrozen()) {
            this.mInlineImageSpan = this.mInlineImageSpan.mutableCopy();
        }
        return this.mInlineImageSpan;
    }
}

