/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

class NodeRegion {
    static final NodeRegion[] EMPTY_ARRAY = new NodeRegion[0];
    static final NodeRegion EMPTY = new NodeRegion(0.0f, 0.0f, 0.0f, 0.0f, -1, false);
    private final float mLeft;
    private final float mTop;
    private final float mRight;
    private final float mBottom;
    final int mTag;
    final boolean mIsVirtual;

    NodeRegion(float left, float top, float right, float bottom, int tag, boolean isVirtual) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
        this.mTag = tag;
        this.mIsVirtual = isVirtual;
    }

    final boolean matches(float left, float top, float right, float bottom, boolean isVirtual) {
        return left == this.mLeft && top == this.mTop && right == this.mRight && bottom == this.mBottom && isVirtual == this.mIsVirtual;
    }

    final float getLeft() {
        return this.mLeft;
    }

    final float getTop() {
        return this.mTop;
    }

    final float getRight() {
        return this.mRight;
    }

    final float getBottom() {
        return this.mBottom;
    }

    float getTouchableLeft() {
        return this.getLeft();
    }

    float getTouchableTop() {
        return this.getTop();
    }

    float getTouchableRight() {
        return this.getRight();
    }

    float getTouchableBottom() {
        return this.getBottom();
    }

    boolean withinBounds(float touchX, float touchY) {
        return this.mLeft <= touchX && touchX < this.mRight && this.mTop <= touchY && touchY < this.mBottom;
    }

    int getReactTag(float touchX, float touchY) {
        return this.mTag;
    }

    boolean matchesTag(int tag) {
        return this.mTag == tag;
    }
}

