/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;

public final class DefaultStyleValuesUtil {
    private DefaultStyleValuesUtil() {
        throw new AssertionError((Object)"Never invoke this for an Utility class!");
    }

    public static ColorStateList getDefaultTextColorHint(Context context) {
        return DefaultStyleValuesUtil.getDefaultTextAttribute(context, 16842906);
    }

    public static ColorStateList getDefaultTextColor(Context context) {
        return DefaultStyleValuesUtil.getDefaultTextAttribute(context, 16842904);
    }

    public static int getDefaultTextColorHighlight(Context context) {
        return DefaultStyleValuesUtil.getDefaultTextAttribute(context, 0x1010099).getDefaultColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColorStateList getDefaultTextAttribute(Context context, int attribute) {
        Resources.Theme theme = context.getTheme();
        TypedArray textAppearances = null;
        try {
            ColorStateList textColor;
            textAppearances = theme.obtainStyledAttributes(new int[]{attribute});
            ColorStateList colorStateList = textColor = textAppearances.getColorStateList(0);
            return colorStateList;
        }
        finally {
            if (textAppearances != null) {
                textAppearances.recycle();
            }
        }
    }
}

