/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.fabric.RootShadowNodeRegistry;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.common.MeasureSpecProvider;
import com.facebook.react.uimanager.common.SizeMonitoringFrameLayout;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class FabricUIManager
implements UIManager {
    private static final String TAG = FabricUIManager.class.toString();
    private final RootShadowNodeRegistry mRootShadowNodeRegistry = new RootShadowNodeRegistry();
    private final ReactApplicationContext mReactApplicationContext;
    private final ViewManagerRegistry mViewManagerRegistry;
    private final UIViewOperationQueue mUIViewOperationQueue;

    public FabricUIManager(ReactApplicationContext reactContext, ViewManagerRegistry viewManagerRegistry) {
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mReactApplicationContext = reactContext;
        this.mViewManagerRegistry = viewManagerRegistry;
        this.mUIViewOperationQueue = new UIViewOperationQueue(reactContext, new NativeViewHierarchyManager(viewManagerRegistry), 0);
    }

    @Nullable
    public ReactShadowNode createNode(int reactTag, String viewName, int rootTag, ReadableNativeMap props) {
        try {
            ViewManager viewManager = this.mViewManagerRegistry.get(viewName);
            Object node = viewManager.createShadowNodeInstance(this.mReactApplicationContext);
            ReactShadowNode rootNode = this.getRootNode(rootTag);
            node.setRootNode((ReactShadowNode)rootNode);
            node.setViewClassName(viewName);
            node.setReactTag(reactTag);
            node.setThemedContext(rootNode.getThemedContext());
            ReactStylesDiffMap styles = this.updateProps((ReactShadowNode)node, props);
            if (!node.isVirtual()) {
                this.mUIViewOperationQueue.enqueueCreateView(rootNode.getThemedContext(), reactTag, viewName, styles);
            }
            return node;
        }
        catch (Throwable t) {
            this.handleException(this.getRootNode(rootTag), t);
            return null;
        }
    }

    private ReactShadowNode getRootNode(int rootTag) {
        return this.mRootShadowNodeRegistry.getNode(rootTag);
    }

    private ReactStylesDiffMap updateProps(ReactShadowNode node, @Nullable ReadableNativeMap props) {
        ReactStylesDiffMap styles = null;
        if (props != null) {
            styles = new ReactStylesDiffMap(props);
            node.updateProperties(styles);
        }
        return styles;
    }

    @Nullable
    public ReactShadowNode cloneNode(ReactShadowNode node) {
        try {
            Object clone = node.mutableCopy();
            this.assertReactShadowNodeCopy(node, (ReactShadowNode)clone);
            return clone;
        }
        catch (Throwable t) {
            this.handleException(node, t);
            return null;
        }
    }

    @Nullable
    public ReactShadowNode cloneNodeWithNewChildren(ReactShadowNode node) {
        try {
            Object clone = node.mutableCopyWithNewChildren();
            this.assertReactShadowNodeCopy(node, (ReactShadowNode)clone);
            return clone;
        }
        catch (Throwable t) {
            this.handleException(node, t);
            return null;
        }
    }

    @Nullable
    public ReactShadowNode cloneNodeWithNewProps(ReactShadowNode node, @Nullable ReadableNativeMap newProps) {
        try {
            Object clone = node.mutableCopyWithNewProps(newProps == null ? null : new ReactStylesDiffMap(newProps));
            this.assertReactShadowNodeCopy(node, (ReactShadowNode)clone);
            return clone;
        }
        catch (Throwable t) {
            this.handleException(node, t);
            return null;
        }
    }

    @Nullable
    public ReactShadowNode cloneNodeWithNewChildrenAndProps(ReactShadowNode node, ReadableNativeMap newProps) {
        try {
            Object clone = node.mutableCopyWithNewChildrenAndProps(newProps == null ? null : new ReactStylesDiffMap(newProps));
            this.assertReactShadowNodeCopy(node, (ReactShadowNode)clone);
            return clone;
        }
        catch (Throwable t) {
            this.handleException(node, t);
            return null;
        }
    }

    private void assertReactShadowNodeCopy(ReactShadowNode source, ReactShadowNode target) {
        Assertions.assertCondition((boolean)source.getClass().equals(target.getClass()), (String)("Found " + target.getClass() + " class when expecting: " + source.getClass() + ". Check that " + source.getClass() + " implements the mutableCopy() method correctly."));
    }

    @Nullable
    public void appendChild(ReactShadowNode parent, ReactShadowNode child) {
        try {
            int childIndex = parent.getChildCount();
            parent.addChildAt(child, childIndex);
            ViewAtIndex[] viewsToAdd = new ViewAtIndex[]{new ViewAtIndex(child.getReactTag(), childIndex)};
            if (!child.isVirtual()) {
                this.mUIViewOperationQueue.enqueueManageChildren(parent.getReactTag(), null, viewsToAdd, null);
            }
        }
        catch (Throwable t) {
            this.handleException(parent, t);
        }
    }

    public List<ReactShadowNode> createChildSet(int rootTag) {
        return new ArrayList<ReactShadowNode>(1);
    }

    public void appendChildToSet(List<ReactShadowNode> childList, ReactShadowNode child) {
        childList.add(child);
    }

    public void completeRoot(int rootTag, List<ReactShadowNode> childList) {
        try {
            ReactShadowNode rootNode = this.getRootNode(rootTag);
            Assertions.assertNotNull((Object)rootNode, (String)("Root view with tag " + rootTag + " must be added before completeRoot is called"));
            for (int i = 0; i < childList.size(); ++i) {
                ReactShadowNode child = childList.get(i);
                this.appendChild(rootNode, child);
            }
            this.notifyOnBeforeLayoutRecursive(rootNode);
            this.calculateRootLayout(rootNode);
            this.applyUpdatesRecursive(rootNode, 0.0f, 0.0f);
            this.mUIViewOperationQueue.dispatchViewUpdates(1, System.currentTimeMillis(), System.currentTimeMillis());
        }
        catch (Exception e) {
            this.handleException(this.getRootNode(rootTag), e);
        }
    }

    private void notifyOnBeforeLayoutRecursive(ReactShadowNode node) {
        if (!node.hasUpdates()) {
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.notifyOnBeforeLayoutRecursive((ReactShadowNode)node.getChildAt(i));
        }
        node.onBeforeLayout();
    }

    private void calculateRootLayout(ReactShadowNode cssRoot) {
        cssRoot.calculateLayout();
    }

    private void applyUpdatesRecursive(ReactShadowNode cssNode, float absoluteX, float absoluteY) {
        int tag;
        if (!cssNode.hasUpdates()) {
            return;
        }
        if (!cssNode.isVirtualAnchor()) {
            for (int i = 0; i < cssNode.getChildCount(); ++i) {
                this.applyUpdatesRecursive((ReactShadowNode)cssNode.getChildAt(i), absoluteX + cssNode.getLayoutX(), absoluteY + cssNode.getLayoutY());
            }
        }
        if (this.mRootShadowNodeRegistry.getNode(tag = cssNode.getReactTag()) == null) {
            boolean bl = cssNode.dispatchUpdates(absoluteX, absoluteY, this.mUIViewOperationQueue, null);
        }
        cssNode.markUpdateSeen();
    }

    @Override
    public <T extends SizeMonitoringFrameLayout> int addRootView(T rootView) {
        int rootTag = ReactRootViewTagGenerator.getNextRootViewTag();
        ThemedReactContext themedRootContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext());
        ReactShadowNode rootShadowNode = this.createRootShadowNode(rootTag, themedRootContext);
        int widthMeasureSpec = ((MeasureSpecProvider)((Object)rootView)).getWidthMeasureSpec();
        int heightMeasureSpec = ((MeasureSpecProvider)((Object)rootView)).getHeightMeasureSpec();
        this.updateRootView(rootShadowNode, widthMeasureSpec, heightMeasureSpec);
        this.mRootShadowNodeRegistry.addNode(rootShadowNode);
        this.mUIViewOperationQueue.addRootView(rootTag, rootView, themedRootContext);
        return rootTag;
    }

    public void removeRootView(int rootTag) {
        this.mRootShadowNodeRegistry.removeNode(rootTag);
    }

    private ReactShadowNode createRootShadowNode(int rootTag, ThemedReactContext themedReactContext) {
        ReactShadowNodeImpl rootNode = new ReactShadowNodeImpl();
        I18nUtil sharedI18nUtilInstance = I18nUtil.getInstance();
        rootNode.setViewClassName("Root");
        rootNode.setReactTag(rootTag);
        rootNode.setThemedContext(themedReactContext);
        return rootNode;
    }

    public void updateRootView(ReactShadowNode rootCSSNode, int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (widthMode) {
            case 0x40000000: {
                rootCSSNode.setStyleWidth(widthSize);
                break;
            }
            case -2147483648: {
                rootCSSNode.setStyleMaxWidth(widthSize);
                break;
            }
            case 0: {
                rootCSSNode.setStyleWidthAuto();
            }
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (heightMode) {
            case 0x40000000: {
                rootCSSNode.setStyleHeight(heightSize);
                break;
            }
            case -2147483648: {
                rootCSSNode.setStyleMaxHeight(heightSize);
                break;
            }
            case 0: {
                rootCSSNode.setStyleHeightAuto();
            }
        }
    }

    private void handleException(ReactShadowNode node, Throwable t) {
        try {
            ThemedReactContext context = node.getThemedContext();
            context.handleException(new RuntimeException(t));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception while executing a Fabric method", (Throwable)t);
            throw new RuntimeException(ex.getMessage(), t);
        }
    }
}

