/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactInstancePackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;

public class CompositeReactPackage
extends ReactInstancePackage
implements ViewManagerOnDemandReactPackage {
    private final List<ReactPackage> mChildReactPackages = new ArrayList<ReactPackage>();

    public CompositeReactPackage(ReactPackage arg1, ReactPackage arg2, ReactPackage ... args) {
        this.mChildReactPackages.add(arg1);
        this.mChildReactPackages.add(arg2);
        Collections.addAll(this.mChildReactPackages, args);
    }

    @Override
    public List<NativeModule> createNativeModules(ReactApplicationContext reactContext) {
        HashMap<String, NativeModule> moduleMap = new HashMap<String, NativeModule>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (NativeModule nativeModule : reactPackage.createNativeModules(reactContext)) {
                moduleMap.put(nativeModule.getName(), nativeModule);
            }
        }
        return new ArrayList<NativeModule>(moduleMap.values());
    }

    @Override
    public List<NativeModule> createNativeModules(ReactApplicationContext reactContext, ReactInstanceManager reactInstanceManager) {
        HashMap<String, NativeModule> moduleMap = new HashMap<String, NativeModule>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            List<NativeModule> nativeModules;
            if (reactPackage instanceof ReactInstancePackage) {
                ReactInstancePackage reactInstancePackage = (ReactInstancePackage)reactPackage;
                nativeModules = reactInstancePackage.createNativeModules(reactContext, reactInstanceManager);
            } else {
                nativeModules = reactPackage.createNativeModules(reactContext);
            }
            for (NativeModule nativeModule : nativeModules) {
                moduleMap.put(nativeModule.getName(), nativeModule);
            }
        }
        return new ArrayList<NativeModule>(moduleMap.values());
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        HashMap<String, ViewManager> viewManagerMap = new HashMap<String, ViewManager>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (ViewManager viewManager : reactPackage.createViewManagers(reactContext)) {
                viewManagerMap.put(viewManager.getName(), viewManager);
            }
        }
        return new ArrayList<ViewManager>(viewManagerMap.values());
    }

    @Override
    public List<String> getViewManagerNames(ReactApplicationContext reactContext, boolean loadClasses) {
        HashSet<String> uniqueNames = new HashSet<String>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            List<String> names;
            if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (names = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).getViewManagerNames(reactContext, loadClasses)) == null) continue;
            uniqueNames.addAll(names);
        }
        return new ArrayList<String>(uniqueNames);
    }

    @Override
    @Nullable
    public ViewManager createViewManager(ReactApplicationContext reactContext, String viewManagerName, boolean loadClasses) {
        ListIterator<ReactPackage> iterator = this.mChildReactPackages.listIterator(this.mChildReactPackages.size());
        while (iterator.hasPrevious()) {
            ViewManager viewManager;
            ReactPackage reactPackage = iterator.previous();
            if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (viewManager = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).createViewManager(reactContext, viewManagerName, loadClasses)) == null) continue;
            return viewManager;
        }
        return null;
    }
}

