/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.util.JsonReader;
import android.util.JsonToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import okio.BufferedSource;

public class BundleDeltaClient {
    final LinkedHashMap<Number, byte[]> mPreModules = new LinkedHashMap();
    final LinkedHashMap<Number, byte[]> mDeltaModules = new LinkedHashMap();
    final LinkedHashMap<Number, byte[]> mPostModules = new LinkedHashMap();
    @Nullable
    String mDeltaId;

    static boolean isDeltaUrl(String bundleUrl) {
        return bundleUrl.indexOf(".delta?") != -1;
    }

    public void reset() {
        this.mDeltaId = null;
        this.mDeltaModules.clear();
        this.mPreModules.clear();
        this.mPostModules.clear();
    }

    public String toDeltaUrl(String bundleURL) {
        if (BundleDeltaClient.isDeltaUrl(bundleURL) && this.mDeltaId != null) {
            return bundleURL + "&deltaBundleId=" + this.mDeltaId;
        }
        return bundleURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean storeDeltaInFile(BufferedSource body, File outputFile) throws IOException {
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(body.inputStream()));
        jsonReader.beginObject();
        int numChangedModules = 0;
        while (jsonReader.hasNext()) {
            String name = jsonReader.nextName();
            if (name.equals("id")) {
                this.mDeltaId = jsonReader.nextString();
                continue;
            }
            if (name.equals("pre")) {
                numChangedModules += BundleDeltaClient.patchDelta(jsonReader, this.mPreModules);
                continue;
            }
            if (name.equals("post")) {
                numChangedModules += BundleDeltaClient.patchDelta(jsonReader, this.mPostModules);
                continue;
            }
            if (name.equals("delta")) {
                numChangedModules += BundleDeltaClient.patchDelta(jsonReader, this.mDeltaModules);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        jsonReader.close();
        if (numChangedModules == 0) {
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        try {
            for (byte[] code : this.mPreModules.values()) {
                fileOutputStream.write(code);
                fileOutputStream.write(10);
            }
            for (byte[] code : this.mDeltaModules.values()) {
                fileOutputStream.write(code);
                fileOutputStream.write(10);
            }
            for (byte[] code : this.mPostModules.values()) {
                fileOutputStream.write(code);
                fileOutputStream.write(10);
            }
        }
        finally {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        return true;
    }

    private static int patchDelta(JsonReader jsonReader, LinkedHashMap<Number, byte[]> map) throws IOException {
        jsonReader.beginArray();
        int numModules = 0;
        while (jsonReader.hasNext()) {
            jsonReader.beginArray();
            int moduleId = jsonReader.nextInt();
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.skipValue();
                map.remove(moduleId);
            } else {
                map.put(moduleId, jsonReader.nextString().getBytes());
            }
            jsonReader.endArray();
            ++numModules;
        }
        jsonReader.endArray();
        return numModules;
    }
}

