/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.net.Uri;
import com.facebook.common.internal.Objects;
import com.facebook.imagepipeline.request.ImageRequest;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MediaVariations {
    public static final String SOURCE_IMAGE_REQUEST = "request";
    public static final String SOURCE_INDEX_DB = "index_db";
    public static final String SOURCE_ID_EXTRACTOR = "id_extractor";
    private final String mMediaId;
    @Nullable
    private final List<Variant> mVariants;
    private final boolean mForceRequestForSpecifiedUri;
    private final String mSource;

    private MediaVariations(Builder builder) {
        this.mMediaId = builder.mMediaId;
        this.mVariants = builder.mVariants;
        this.mForceRequestForSpecifiedUri = builder.mForceRequestForSpecifiedUri;
        this.mSource = builder.mSource;
    }

    public String getMediaId() {
        return this.mMediaId;
    }

    public int getVariantsCount() {
        return this.mVariants == null ? 0 : this.mVariants.size();
    }

    public Variant getVariant(int index) {
        return this.mVariants.get(index);
    }

    public List<Variant> getSortedVariants(Comparator<Variant> comparator) {
        int variantsCount = this.getVariantsCount();
        if (variantsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<Variant> variants = new ArrayList<Variant>(variantsCount);
        for (int i = 0; i < variantsCount; ++i) {
            variants.add(this.mVariants.get(i));
        }
        Collections.sort(variants, comparator);
        return variants;
    }

    public boolean shouldForceRequestForSpecifiedUri() {
        return this.mForceRequestForSpecifiedUri;
    }

    public String getSource() {
        return this.mSource;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MediaVariations)) {
            return false;
        }
        MediaVariations otherVariations = (MediaVariations)o;
        return Objects.equal((Object)this.mMediaId, (Object)otherVariations.mMediaId) && this.mForceRequestForSpecifiedUri == otherVariations.mForceRequestForSpecifiedUri && Objects.equal(this.mVariants, otherVariations.mVariants);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mMediaId, this.mForceRequestForSpecifiedUri, this.mVariants, this.mSource});
    }

    public String toString() {
        return String.format((Locale)null, "%s-%b-%s-%s", this.mMediaId, this.mForceRequestForSpecifiedUri, this.mVariants, this.mSource);
    }

    @Nullable
    public static MediaVariations forMediaId(@Nullable String mediaId) {
        if (mediaId == null || mediaId.isEmpty()) {
            return null;
        }
        return MediaVariations.newBuilderForMediaId(mediaId).build();
    }

    public static Builder newBuilderForMediaId(String mediaId) {
        return new Builder(mediaId);
    }

    public static class Builder {
        private final String mMediaId;
        private List<Variant> mVariants;
        private boolean mForceRequestForSpecifiedUri = false;
        private String mSource = "request";

        private Builder(String mediaId) {
            this.mMediaId = mediaId;
        }

        public Builder addVariant(Uri uri, int width, int height) {
            return this.addVariant(uri, width, height, null);
        }

        public Builder addVariant(Uri uri, int width, int height, ImageRequest.CacheChoice cacheChoice) {
            if (this.mVariants == null) {
                this.mVariants = new ArrayList<Variant>();
            }
            this.mVariants.add(new Variant(uri, width, height, cacheChoice));
            return this;
        }

        public Builder setForceRequestForSpecifiedUri(boolean forceRequestForSpecifiedUri) {
            this.mForceRequestForSpecifiedUri = forceRequestForSpecifiedUri;
            return this;
        }

        public Builder setSource(String source) {
            this.mSource = source;
            return this;
        }

        public MediaVariations build() {
            return new MediaVariations(this);
        }
    }

    public static final class Variant {
        private final Uri mUri;
        private final int mWidth;
        private final int mHeight;
        @Nullable
        private final ImageRequest.CacheChoice mCacheChoice;

        public Variant(Uri uri, int width, int height) {
            this(uri, width, height, null);
        }

        public Variant(Uri uri, int width, int height, @Nullable ImageRequest.CacheChoice cacheChoice) {
            this.mUri = uri;
            this.mWidth = width;
            this.mHeight = height;
            this.mCacheChoice = cacheChoice;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        @Nullable
        public ImageRequest.CacheChoice getCacheChoice() {
            return this.mCacheChoice;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Variant)) {
                return false;
            }
            Variant otherVariant = (Variant)o;
            return Objects.equal((Object)this.mUri, (Object)otherVariant.mUri) && this.mWidth == otherVariant.mWidth && this.mHeight == otherVariant.mHeight && this.mCacheChoice == otherVariant.mCacheChoice;
        }

        public int hashCode() {
            int hashCode = this.mUri.hashCode();
            hashCode = 31 * hashCode + this.mWidth;
            hashCode = 31 * hashCode + this.mHeight;
            return hashCode;
        }

        public String toString() {
            return String.format((Locale)null, "%dx%d %s %s", new Object[]{this.mWidth, this.mHeight, this.mUri, this.mCacheChoice});
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }
}

