/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import com.facebook.soloader.SysUtil;
import com.facebook.soloader.UnpackingSoSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExtractFromZipSoSource
extends UnpackingSoSource {
    protected final File mZipFileName;
    protected final String mZipSearchPattern;

    public ExtractFromZipSoSource(Context context, String name, File zipFileName, String zipSearchPattern) {
        super(context, name);
        this.mZipFileName = zipFileName;
        this.mZipSearchPattern = zipSearchPattern;
    }

    @Override
    protected UnpackingSoSource.Unpacker makeUnpacker() throws IOException {
        return new ZipUnpacker();
    }

    private static final class ZipDso
    extends UnpackingSoSource.Dso
    implements Comparable {
        final ZipEntry backingEntry;
        final int abiScore;

        ZipDso(String name, ZipEntry backingEntry, int abiScore) {
            super(name, ZipDso.makePseudoHash(backingEntry));
            this.backingEntry = backingEntry;
            this.abiScore = abiScore;
        }

        private static String makePseudoHash(ZipEntry ze) {
            return String.format("pseudo-zip-hash-1-%s-%s-%s-%s", ze.getName(), ze.getSize(), ze.getCompressedSize(), ze.getCrc());
        }

        public int compareTo(Object other) {
            return this.name.compareTo(((ZipDso)other).name);
        }
    }

    protected class ZipUnpacker
    extends UnpackingSoSource.Unpacker {
        private ZipDso[] mDsos;
        private final ZipFile mZipFile;

        ZipUnpacker() throws IOException {
            this.mZipFile = new ZipFile(ExtractFromZipSoSource.this.mZipFileName);
        }

        final ZipDso[] ensureDsos() {
            if (this.mDsos == null) {
                HashMap<String, ZipDso> providedLibraries = new HashMap<String, ZipDso>();
                Pattern zipSearchPattern = Pattern.compile(ExtractFromZipSoSource.this.mZipSearchPattern);
                String[] supportedAbis = SysUtil.getSupportedAbis();
                Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipDso so;
                    ZipEntry entry = entries.nextElement();
                    Matcher m = zipSearchPattern.matcher(entry.getName());
                    if (!m.matches()) continue;
                    String libraryAbi = m.group(1);
                    String soName = m.group(2);
                    int abiScore = SysUtil.findAbiScore(supportedAbis, libraryAbi);
                    if (abiScore < 0 || (so = (ZipDso)providedLibraries.get(soName)) != null && abiScore >= so.abiScore) continue;
                    providedLibraries.put(soName, new ZipDso(soName, entry, abiScore));
                }
                Object[] dsos = providedLibraries.values().toArray(new ZipDso[providedLibraries.size()]);
                Arrays.sort(dsos);
                int nrFilteredDsos = 0;
                for (int i = 0; i < dsos.length; ++i) {
                    Object zd = dsos[i];
                    if (this.shouldExtract(((ZipDso)zd).backingEntry, ((ZipDso)zd).name)) {
                        ++nrFilteredDsos;
                        continue;
                    }
                    dsos[i] = null;
                }
                ZipDso[] filteredDsos = new ZipDso[nrFilteredDsos];
                int j = 0;
                for (int i = 0; i < dsos.length; ++i) {
                    Object zd = dsos[i];
                    if (zd == null) continue;
                    filteredDsos[j++] = zd;
                }
                this.mDsos = filteredDsos;
            }
            return this.mDsos;
        }

        protected boolean shouldExtract(ZipEntry ze, String soName) {
            return true;
        }

        @Override
        public void close() throws IOException {
            this.mZipFile.close();
        }

        @Override
        protected final UnpackingSoSource.DsoManifest getDsoManifest() throws IOException {
            return new UnpackingSoSource.DsoManifest(this.ensureDsos());
        }

        @Override
        protected final UnpackingSoSource.InputDsoIterator openDsoIterator() throws IOException {
            return new ZipBackedInputDsoIterator();
        }

        private final class ZipBackedInputDsoIterator
        extends UnpackingSoSource.InputDsoIterator {
            private int mCurrentDso;

            private ZipBackedInputDsoIterator() {
            }

            @Override
            public boolean hasNext() {
                ZipUnpacker.this.ensureDsos();
                return this.mCurrentDso < ZipUnpacker.this.mDsos.length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UnpackingSoSource.InputDso next() throws IOException {
                ZipUnpacker.this.ensureDsos();
                ZipDso zipDso = ZipUnpacker.this.mDsos[this.mCurrentDso++];
                try (InputStream is = ZipUnpacker.this.mZipFile.getInputStream(zipDso.backingEntry);){
                    UnpackingSoSource.InputDso ret = new UnpackingSoSource.InputDso(zipDso, is);
                    is = null;
                    UnpackingSoSource.InputDso inputDso = ret;
                    return inputDso;
                }
            }
        }
    }
}

