/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.common.internal.Supplier;
import com.facebook.common.webp.WebpBitmapFactory;
import com.facebook.imagepipeline.cache.MediaIdExtractor;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import javax.annotation.Nullable;

public class ImagePipelineExperiments {
    private final int mForceSmallCacheThresholdBytes;
    private final boolean mWebpSupportEnabled;
    private final boolean mExternalCreatedBitmapLogEnabled;
    private final Supplier<Boolean> mMediaVariationsIndexEnabled;
    private final MediaIdExtractor mMediaIdExtractor;
    private final WebpBitmapFactory.WebpErrorLogger mWebpErrorLogger;
    private final boolean mDecodeCancellationEnabled;
    private final WebpBitmapFactory mWebpBitmapFactory;
    private final boolean mSuppressBitmapPrefetching;
    private final boolean mUseDownsamplingRatioForResizing;

    private ImagePipelineExperiments(Builder builder, ImagePipelineConfig.Builder configBuilder) {
        this.mForceSmallCacheThresholdBytes = builder.mForceSmallCacheThresholdBytes;
        this.mWebpSupportEnabled = builder.mWebpSupportEnabled;
        this.mExternalCreatedBitmapLogEnabled = builder.mExternalCreatedBitmapLogEnabled;
        this.mMediaVariationsIndexEnabled = builder.mMediaVariationsIndexEnabled != null ? builder.mMediaVariationsIndexEnabled : new Supplier<Boolean>(){

            public Boolean get() {
                return Boolean.FALSE;
            }
        };
        this.mMediaIdExtractor = builder.mMediaIdExtractor;
        this.mWebpErrorLogger = builder.mWebpErrorLogger;
        this.mDecodeCancellationEnabled = builder.mDecodeCancellationEnabled;
        this.mWebpBitmapFactory = builder.mWebpBitmapFactory;
        this.mSuppressBitmapPrefetching = builder.mSuppressBitmapPrefetching;
        this.mUseDownsamplingRatioForResizing = builder.mUseDownsamplingRatioForResizing;
    }

    public boolean isExternalCreatedBitmapLogEnabled() {
        return this.mExternalCreatedBitmapLogEnabled;
    }

    public int getForceSmallCacheThresholdBytes() {
        return this.mForceSmallCacheThresholdBytes;
    }

    public boolean getMediaVariationsIndexEnabled() {
        return (Boolean)this.mMediaVariationsIndexEnabled.get();
    }

    @Nullable
    public MediaIdExtractor getMediaIdExtractor() {
        return this.mMediaIdExtractor;
    }

    public boolean getUseDownsamplingRatioForResizing() {
        return this.mUseDownsamplingRatioForResizing;
    }

    public boolean isWebpSupportEnabled() {
        return this.mWebpSupportEnabled;
    }

    public boolean isDecodeCancellationEnabled() {
        return this.mDecodeCancellationEnabled;
    }

    public WebpBitmapFactory.WebpErrorLogger getWebpErrorLogger() {
        return this.mWebpErrorLogger;
    }

    public WebpBitmapFactory getWebpBitmapFactory() {
        return this.mWebpBitmapFactory;
    }

    public static Builder newBuilder(ImagePipelineConfig.Builder configBuilder) {
        return new Builder(configBuilder);
    }

    public static class Builder {
        private final ImagePipelineConfig.Builder mConfigBuilder;
        private int mForceSmallCacheThresholdBytes = 0;
        private boolean mWebpSupportEnabled = false;
        private boolean mExternalCreatedBitmapLogEnabled = false;
        private Supplier<Boolean> mMediaVariationsIndexEnabled = null;
        private MediaIdExtractor mMediaIdExtractor;
        private WebpBitmapFactory.WebpErrorLogger mWebpErrorLogger;
        private boolean mDecodeCancellationEnabled = false;
        private WebpBitmapFactory mWebpBitmapFactory;
        private boolean mSuppressBitmapPrefetching = false;
        private boolean mUseDownsamplingRatioForResizing = false;

        public Builder(ImagePipelineConfig.Builder configBuilder) {
            this.mConfigBuilder = configBuilder;
        }

        public ImagePipelineConfig.Builder setExternalCreatedBitmapLogEnabled(boolean externalCreatedBitmapLogEnabled) {
            this.mExternalCreatedBitmapLogEnabled = externalCreatedBitmapLogEnabled;
            return this.mConfigBuilder;
        }

        @Deprecated
        public ImagePipelineConfig.Builder setForceSmallCacheThresholdBytes(int forceSmallCacheThresholdBytes) {
            this.mForceSmallCacheThresholdBytes = forceSmallCacheThresholdBytes;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setMediaVariationsIndexEnabled(Supplier<Boolean> mediaVariationsIndexEnabled) {
            this.mMediaVariationsIndexEnabled = mediaVariationsIndexEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setMediaIdExtractor(MediaIdExtractor mediaIdExtractor) {
            this.mMediaIdExtractor = mediaIdExtractor;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpSupportEnabled(boolean webpSupportEnabled) {
            this.mWebpSupportEnabled = webpSupportEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setUseDownsampligRatioForResizing(boolean useDownsamplingRatioForResizing) {
            this.mUseDownsamplingRatioForResizing = useDownsamplingRatioForResizing;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setDecodeCancellationEnabled(boolean decodeCancellationEnabled) {
            this.mDecodeCancellationEnabled = decodeCancellationEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpErrorLogger(WebpBitmapFactory.WebpErrorLogger webpErrorLogger) {
            this.mWebpErrorLogger = webpErrorLogger;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpBitmapFactory(WebpBitmapFactory webpBitmapFactory) {
            this.mWebpBitmapFactory = webpBitmapFactory;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setSuppressBitmapPrefetching(boolean suppressBitmapPrefetching) {
            this.mSuppressBitmapPrefetching = suppressBitmapPrefetching;
            return this.mConfigBuilder;
        }

        public ImagePipelineExperiments build() {
            return new ImagePipelineExperiments(this, this.mConfigBuilder);
        }
    }
}

