/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaWrap;
import javax.annotation.Nullable;

public class LayoutShadowNode
extends ReactShadowNodeImpl {
    private final MutableYogaValue mTempYogaValue;

    public LayoutShadowNode() {
        this.mTempYogaValue = new MutableYogaValue();
    }

    protected LayoutShadowNode(LayoutShadowNode node) {
        super(node);
        this.mTempYogaValue = new MutableYogaValue(node.mTempYogaValue);
    }

    @Override
    public LayoutShadowNode mutableCopy() {
        return new LayoutShadowNode(this);
    }

    @ReactProp(name="width")
    public void setWidth(Dynamic width) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(width);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleWidth(this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setStyleWidthAuto();
                break;
            }
            case PERCENT: {
                this.setStyleWidthPercent(this.mTempYogaValue.value);
            }
        }
        width.recycle();
    }

    @ReactProp(name="minWidth")
    public void setMinWidth(Dynamic minWidth) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(minWidth);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMinWidth(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMinWidthPercent(this.mTempYogaValue.value);
            }
        }
        minWidth.recycle();
    }

    @ReactProp(name="maxWidth")
    public void setMaxWidth(Dynamic maxWidth) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(maxWidth);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMaxWidth(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMaxWidthPercent(this.mTempYogaValue.value);
            }
        }
        maxWidth.recycle();
    }

    @ReactProp(name="height")
    public void setHeight(Dynamic height) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(height);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleHeight(this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setStyleHeightAuto();
                break;
            }
            case PERCENT: {
                this.setStyleHeightPercent(this.mTempYogaValue.value);
            }
        }
        height.recycle();
    }

    @ReactProp(name="minHeight")
    public void setMinHeight(Dynamic minHeight) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(minHeight);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMinHeight(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMinHeightPercent(this.mTempYogaValue.value);
            }
        }
        minHeight.recycle();
    }

    @ReactProp(name="maxHeight")
    public void setMaxHeight(Dynamic maxHeight) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(maxHeight);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMaxHeight(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMaxHeightPercent(this.mTempYogaValue.value);
            }
        }
        maxHeight.recycle();
    }

    @Override
    @ReactProp(name="flex", defaultFloat=0.0f)
    public void setFlex(float flex) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlex(flex);
    }

    @Override
    @ReactProp(name="flexGrow", defaultFloat=0.0f)
    public void setFlexGrow(float flexGrow) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlexGrow(flexGrow);
    }

    @Override
    @ReactProp(name="flexShrink", defaultFloat=0.0f)
    public void setFlexShrink(float flexShrink) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlexShrink(flexShrink);
    }

    @ReactProp(name="flexBasis")
    public void setFlexBasis(Dynamic flexBasis) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(flexBasis);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setFlexBasis(this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setFlexBasisAuto();
                break;
            }
            case PERCENT: {
                this.setFlexBasisPercent(this.mTempYogaValue.value);
            }
        }
        flexBasis.recycle();
    }

    @ReactProp(name="aspectRatio", defaultFloat=1.0E21f)
    public void setAspectRatio(float aspectRatio) {
        this.setStyleAspectRatio(aspectRatio);
    }

    @ReactProp(name="flexDirection")
    public void setFlexDirection(@Nullable String flexDirection) {
        if (this.isVirtual()) {
            return;
        }
        if (flexDirection == null) {
            this.setFlexDirection(YogaFlexDirection.COLUMN);
            return;
        }
        switch (flexDirection) {
            case "column": {
                this.setFlexDirection(YogaFlexDirection.COLUMN);
                break;
            }
            case "column-reverse": {
                this.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
                break;
            }
            case "row": {
                this.setFlexDirection(YogaFlexDirection.ROW);
                break;
            }
            case "row-reverse": {
                this.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("invalid value for flexDirection: " + flexDirection);
            }
        }
    }

    @ReactProp(name="flexWrap")
    public void setFlexWrap(@Nullable String flexWrap) {
        if (this.isVirtual()) {
            return;
        }
        if (flexWrap == null) {
            this.setFlexWrap(YogaWrap.NO_WRAP);
            return;
        }
        switch (flexWrap) {
            case "nowrap": {
                this.setFlexWrap(YogaWrap.NO_WRAP);
                break;
            }
            case "wrap": {
                this.setFlexWrap(YogaWrap.WRAP);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("invalid value for flexWrap: " + flexWrap);
            }
        }
    }

    @ReactProp(name="alignSelf")
    public void setAlignSelf(@Nullable String alignSelf) {
        if (this.isVirtual()) {
            return;
        }
        if (alignSelf == null) {
            this.setAlignSelf(YogaAlign.AUTO);
            return;
        }
        switch (alignSelf) {
            case "auto": {
                this.setAlignSelf(YogaAlign.AUTO);
                return;
            }
            case "flex-start": {
                this.setAlignSelf(YogaAlign.FLEX_START);
                return;
            }
            case "center": {
                this.setAlignSelf(YogaAlign.CENTER);
                return;
            }
            case "flex-end": {
                this.setAlignSelf(YogaAlign.FLEX_END);
                return;
            }
            case "stretch": {
                this.setAlignSelf(YogaAlign.STRETCH);
                return;
            }
            case "baseline": {
                this.setAlignSelf(YogaAlign.BASELINE);
                return;
            }
            case "space-between": {
                this.setAlignSelf(YogaAlign.SPACE_BETWEEN);
                return;
            }
            case "space-around": {
                this.setAlignSelf(YogaAlign.SPACE_AROUND);
                return;
            }
        }
        throw new JSApplicationIllegalArgumentException("invalid value for alignSelf: " + alignSelf);
    }

    @ReactProp(name="alignItems")
    public void setAlignItems(@Nullable String alignItems) {
        if (this.isVirtual()) {
            return;
        }
        if (alignItems == null) {
            this.setAlignItems(YogaAlign.STRETCH);
            return;
        }
        switch (alignItems) {
            case "auto": {
                this.setAlignItems(YogaAlign.AUTO);
                return;
            }
            case "flex-start": {
                this.setAlignItems(YogaAlign.FLEX_START);
                return;
            }
            case "center": {
                this.setAlignItems(YogaAlign.CENTER);
                return;
            }
            case "flex-end": {
                this.setAlignItems(YogaAlign.FLEX_END);
                return;
            }
            case "stretch": {
                this.setAlignItems(YogaAlign.STRETCH);
                return;
            }
            case "baseline": {
                this.setAlignItems(YogaAlign.BASELINE);
                return;
            }
            case "space-between": {
                this.setAlignItems(YogaAlign.SPACE_BETWEEN);
                return;
            }
            case "space-around": {
                this.setAlignItems(YogaAlign.SPACE_AROUND);
                return;
            }
        }
        throw new JSApplicationIllegalArgumentException("invalid value for alignItems: " + alignItems);
    }

    @ReactProp(name="alignContent")
    public void setAlignContent(@Nullable String alignContent) {
        if (this.isVirtual()) {
            return;
        }
        if (alignContent == null) {
            this.setAlignContent(YogaAlign.FLEX_START);
            return;
        }
        switch (alignContent) {
            case "auto": {
                this.setAlignContent(YogaAlign.AUTO);
                return;
            }
            case "flex-start": {
                this.setAlignContent(YogaAlign.FLEX_START);
                return;
            }
            case "center": {
                this.setAlignContent(YogaAlign.CENTER);
                return;
            }
            case "flex-end": {
                this.setAlignContent(YogaAlign.FLEX_END);
                return;
            }
            case "stretch": {
                this.setAlignContent(YogaAlign.STRETCH);
                return;
            }
            case "baseline": {
                this.setAlignContent(YogaAlign.BASELINE);
                return;
            }
            case "space-between": {
                this.setAlignContent(YogaAlign.SPACE_BETWEEN);
                return;
            }
            case "space-around": {
                this.setAlignContent(YogaAlign.SPACE_AROUND);
                return;
            }
        }
        throw new JSApplicationIllegalArgumentException("invalid value for alignContent: " + alignContent);
    }

    @ReactProp(name="justifyContent")
    public void setJustifyContent(@Nullable String justifyContent) {
        if (this.isVirtual()) {
            return;
        }
        if (justifyContent == null) {
            this.setJustifyContent(YogaJustify.FLEX_START);
            return;
        }
        switch (justifyContent) {
            case "flex-start": {
                this.setJustifyContent(YogaJustify.FLEX_START);
                break;
            }
            case "center": {
                this.setJustifyContent(YogaJustify.CENTER);
                break;
            }
            case "flex-end": {
                this.setJustifyContent(YogaJustify.FLEX_END);
                break;
            }
            case "space-between": {
                this.setJustifyContent(YogaJustify.SPACE_BETWEEN);
                break;
            }
            case "space-around": {
                this.setJustifyContent(YogaJustify.SPACE_AROUND);
                break;
            }
            case "space-evenly": {
                this.setJustifyContent(YogaJustify.SPACE_EVENLY);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("invalid value for justifyContent: " + justifyContent);
            }
        }
    }

    @ReactProp(name="overflow")
    public void setOverflow(@Nullable String overflow) {
        if (this.isVirtual()) {
            return;
        }
        if (overflow == null) {
            this.setOverflow(YogaOverflow.VISIBLE);
            return;
        }
        switch (overflow) {
            case "visible": {
                this.setOverflow(YogaOverflow.VISIBLE);
                break;
            }
            case "hidden": {
                this.setOverflow(YogaOverflow.HIDDEN);
                break;
            }
            case "scroll": {
                this.setOverflow(YogaOverflow.SCROLL);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("invalid value for overflow: " + overflow);
            }
        }
    }

    @ReactProp(name="display")
    public void setDisplay(@Nullable String display) {
        if (this.isVirtual()) {
            return;
        }
        if (display == null) {
            this.setDisplay(YogaDisplay.FLEX);
            return;
        }
        switch (display) {
            case "flex": {
                this.setDisplay(YogaDisplay.FLEX);
                break;
            }
            case "none": {
                this.setDisplay(YogaDisplay.NONE);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("invalid value for display: " + display);
            }
        }
    }

    @ReactPropGroup(names={"margin", "marginVertical", "marginHorizontal", "marginStart", "marginEnd", "marginTop", "marginBottom", "marginLeft", "marginRight"})
    public void setMargins(int index, Dynamic margin) {
        if (this.isVirtual()) {
            return;
        }
        int spacingType = this.maybeTransformLeftRightToStartEnd(ViewProps.PADDING_MARGIN_SPACING_TYPES[index]);
        this.mTempYogaValue.setFromDynamic(margin);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setMargin(spacingType, this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setMarginAuto(spacingType);
                break;
            }
            case PERCENT: {
                this.setMarginPercent(spacingType, this.mTempYogaValue.value);
            }
        }
        margin.recycle();
    }

    @ReactPropGroup(names={"padding", "paddingVertical", "paddingHorizontal", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom", "paddingLeft", "paddingRight"})
    public void setPaddings(int index, Dynamic padding) {
        if (this.isVirtual()) {
            return;
        }
        int spacingType = this.maybeTransformLeftRightToStartEnd(ViewProps.PADDING_MARGIN_SPACING_TYPES[index]);
        this.mTempYogaValue.setFromDynamic(padding);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setPadding(spacingType, this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setPaddingPercent(spacingType, this.mTempYogaValue.value);
            }
        }
        padding.recycle();
    }

    @ReactPropGroup(names={"borderWidth", "borderStartWidth", "borderEndWidth", "borderTopWidth", "borderBottomWidth", "borderLeftWidth", "borderRightWidth"}, defaultFloat=1.0E21f)
    public void setBorderWidths(int index, float borderWidth) {
        if (this.isVirtual()) {
            return;
        }
        int spacingType = this.maybeTransformLeftRightToStartEnd(ViewProps.BORDER_SPACING_TYPES[index]);
        this.setBorder(spacingType, PixelUtil.toPixelFromDIP(borderWidth));
    }

    @ReactPropGroup(names={"start", "end", "left", "right", "top", "bottom"})
    public void setPositionValues(int index, Dynamic position) {
        if (this.isVirtual()) {
            return;
        }
        int[] POSITION_SPACING_TYPES = new int[]{4, 5, 0, 2, 1, 3};
        int spacingType = this.maybeTransformLeftRightToStartEnd(POSITION_SPACING_TYPES[index]);
        this.mTempYogaValue.setFromDynamic(position);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setPosition(spacingType, this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setPositionPercent(spacingType, this.mTempYogaValue.value);
            }
        }
        position.recycle();
    }

    private int maybeTransformLeftRightToStartEnd(int spacingType) {
        if (!I18nUtil.getInstance().doLeftAndRightSwapInRTL((Context)this.getThemedContext())) {
            return spacingType;
        }
        switch (spacingType) {
            case 0: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return spacingType;
    }

    @ReactProp(name="position")
    public void setPosition(@Nullable String position) {
        if (this.isVirtual()) {
            return;
        }
        if (position == null) {
            this.setPositionType(YogaPositionType.RELATIVE);
            return;
        }
        switch (position) {
            case "relative": {
                this.setPositionType(YogaPositionType.RELATIVE);
                break;
            }
            case "absolute": {
                this.setPositionType(YogaPositionType.ABSOLUTE);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("invalid value for position: " + position);
            }
        }
    }

    @Override
    @ReactProp(name="onLayout")
    public void setShouldNotifyOnLayout(boolean shouldNotifyOnLayout) {
        super.setShouldNotifyOnLayout(shouldNotifyOnLayout);
    }

    private static class MutableYogaValue {
        float value;
        YogaUnit unit;

        private MutableYogaValue() {
        }

        private MutableYogaValue(MutableYogaValue mutableYogaValue) {
            this.value = mutableYogaValue.value;
            this.unit = mutableYogaValue.unit;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void setFromDynamic(Dynamic dynamic) {
            if (dynamic.isNull()) {
                this.unit = YogaUnit.UNDEFINED;
                this.value = 1.0E21f;
                return;
            } else if (dynamic.getType() == ReadableType.String) {
                String s = dynamic.asString();
                if (s.equals("auto")) {
                    this.unit = YogaUnit.AUTO;
                    this.value = 1.0E21f;
                    return;
                } else {
                    if (!s.endsWith("%")) throw new IllegalArgumentException("Unknown value: " + s);
                    this.unit = YogaUnit.PERCENT;
                    this.value = Float.parseFloat(s.substring(0, s.length() - 1));
                }
                return;
            } else {
                this.unit = YogaUnit.POINT;
                this.value = PixelUtil.toPixelFromDIP(dynamic.asDouble());
            }
        }
    }
}

