/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import android.util.Log;
import com.facebook.soloader.ExtractFromZipSoSource;
import com.facebook.soloader.SysUtil;
import com.facebook.soloader.UnpackingSoSource;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class ApkSoSource
extends ExtractFromZipSoSource {
    private static final String TAG = "ApkSoSource";
    public static final int PREFER_ANDROID_LIBS_DIRECTORY = 1;
    private static final byte APK_SIGNATURE_VERSION = 1;
    private final int mFlags;

    public ApkSoSource(Context context, String name, int flags) {
        super(context, name, new File(context.getApplicationInfo().sourceDir), "^lib/([^/]+)/([^/]+\\.so)$");
        this.mFlags = flags;
    }

    @Override
    protected UnpackingSoSource.Unpacker makeUnpacker() throws IOException {
        return new ApkUnpacker();
    }

    @Override
    protected byte[] getDepsBlock() throws IOException {
        return SysUtil.makeApkDepBlock(this.mZipFileName);
    }

    protected class ApkUnpacker
    extends ExtractFromZipSoSource.ZipUnpacker {
        private File mLibDir;
        private final int mFlags;

        ApkUnpacker() throws IOException {
            super(ApkSoSource.this);
            this.mLibDir = new File(ApkSoSource.this.mContext.getApplicationInfo().nativeLibraryDir);
            this.mFlags = ApkSoSource.this.mFlags;
        }

        @Override
        protected boolean shouldExtract(ZipEntry ze, String soName) {
            long apkLibLength;
            String zipPath = ze.getName();
            if ((this.mFlags & 1) == 0) {
                Log.d((String)ApkSoSource.TAG, (String)("allowing consideration of " + zipPath + ": self-extraction preferred"));
                return true;
            }
            File sysLibFile = new File(this.mLibDir, soName);
            if (!sysLibFile.isFile()) {
                Log.d((String)ApkSoSource.TAG, (String)String.format("allowing considering of %s: %s not in system lib dir", zipPath, soName));
                return true;
            }
            long sysLibLength = sysLibFile.length();
            if (sysLibLength != (apkLibLength = ze.getSize())) {
                Log.d((String)ApkSoSource.TAG, (String)String.format("allowing consideration of %s: sysdir file length is %s, but the file is %s bytes long in the APK", sysLibFile, sysLibLength, apkLibLength));
                return true;
            }
            Log.d((String)ApkSoSource.TAG, (String)("not allowing consideration of " + zipPath + ": deferring to libdir"));
            return false;
        }
    }
}

