
#include <vector>
#include <string>
#include <assert.h>
#include "tests.h"

using namespace std;

namespace rule18
{
	namespace x1
	{
		//

		enum class Connect
		{
			Retry = 1,
			InternalServer = 2
		};

		int operator | (Connect connectLeft, Connect connectRight)
		{
			return int(connectLeft) | int(connectRight);
		}

		class ConnectionHandle
		{
		public:

			ConnectionHandle()
				{ ; }

			bool isValid() const
				{ return true;  }
		};

		class Blob
		{
		public:

			Blob()
				{ ; }
		};

		ConnectionHandle connectToStagingServer(const string, int connectFlags)
		{
			return ConnectionHandle();
		}

		void postBlob(ConnectionHandle handle, Blob * blob)
		{
		}

		//

		void postToStagingServer(string url, Blob * payload)
		{
			// Ze względu na użycie Connect::Retry to wywołanie zawsze zwróci prawidłowy uchwyt

			ConnectionHandle handle = connectToStagingServer(
										url,
										Connect::Retry | Connect::InternalServer);

			// Przesyłamy dane 

			postBlob(handle, payload);
		}

	};

	namespace x2
	{
		struct Blob
		{
		};

		/**
		* @brief Przesyła treść do serwera publikującego
		*
		* Próbuje przesłać podane treści do serwera publikującego
		* o podanym adresie i zwraca @c true w przypadku powodzenia
		* lub @c false w razie niepowodzenia z jakiegoś powodu
		*
		* @param url Adres URL serwera
		* @param payload Dane do przesłania
		* @returns @c true w razie powodzenia
		*/
		bool tryPostToStagingServer(string url, Blob * payload);

	};

	namespace x3
	{
		bool findPermutation(const string & p, const string & s)
		{
			int pl = p.length(), sl = s.length();
			if (sl < pl) return false;
			int pcs[CHAR_MAX] = {}, scs[CHAR_MAX] = {};
			for (unsigned char c : p)
			{ ++pcs[c]; }
			int si = 0;
			for (; si < pl; ++si)
			{ ++scs[static_cast<unsigned char>(s[si])]; }
			for (;; ++si)
			{
			for (int pi = 0;; ++pi)
			{
			if (pi >= pl) return true;
			unsigned char c = p[pi];
			if (pcs[c] != scs[c]) break;
			}
			if (si >= sl) break;
			--scs[static_cast<unsigned char>(s[si - pl])];
			++scs[static_cast<unsigned char>(s[si])];
			}
			return false;
		}
	};

	namespace x4
	{
		// Sprawdza, czy permutacja łańcucha permute występuje w łańcuchu search 

		bool tryFindPermutation(const string & permute, const string & search)
		{
			// Jeśli łańcuch search jest krótszy od łańcucha permute,
			// to nie ma możliwości, by permute był permutacją search. W takim przypadku
			// kończymy działanie już teraz, by uprościć dalszy kod

			int permuteLength = permute.length();
			int searchLength = search.length();
			if (searchLength < permuteLength) 
				return false;

			// Zliczamy, ile razy każda litera występuje w łańcuchu permute. Będziemy 
			// porównywać te liczby z licznikami bieżącymi odnoszącymi się do łańcucha search

			int permuteCounts[UCHAR_MAX] = {};
			for (unsigned char c : permute)
			{ 
				++permuteCounts[c]; 
			}

			// Tworzymy te same liczniki dla pierwszego możliwego dopasowania w przeszukiwanym łańcuchu

			int searchCounts[UCHAR_MAX] = {};
			int searchIndex = 0;

			for (; searchIndex < permuteLength; ++searchIndex)
			{ 
				unsigned char c = search[searchIndex];
				++searchCounts[c]; 
			}

			// Pętla po fragmentach łańcucha przeszukiwanego, które być może pasują

			for (;; ++searchIndex)
			{
				// Sprawdzamy, czy bieżący fragment łańcucha pasuje do łańcucha permutacji

				for (int permuteIndex = 0;; ++permuteIndex)
				{
					// Jeśli po sprawdzeniu wszystkich znaków w łańcuchu permutacji nie znajdziemy
					// żadnych rozbieżności w liczbach znaków, to będzie to znaczyło, że znaleźliśmy
					// permutację. Zwracamy zatem true, by poinformować o sukcesie

					if (permuteIndex >= permuteLength) 
						return true;

					// Sprawdzamy bieżący znak w łańcuch permute. Jeśli liczba tych znaków w łańcuchu
					// permute nie odpowiada ich liczbie w łańcuchu search, oznacza to, że to nie jest 
					// permutacja. Przechodzimy zatem do następnego fragmentu łańcucha

					unsigned char c = permute[permuteIndex];
					if (permuteCounts[c] != searchCounts[c]) 
						break;
				}

				// Jeśli sprawdziliśmy wszystkie możliwe fragmenty łańcucha search, kończymy

				if (searchIndex >= searchLength)
					break;

				// Aktualizujemy liczniki bieżące. Inkrementujemy licznik następnego znaku 
				// i dekrementujemy licznik znaków na początku fragmentu łańcucha

				unsigned char drop = search[searchIndex - permuteLength];
				unsigned char add = search[searchIndex];

				--searchCounts[drop]; 
				++searchCounts[add];
			}

			// Jeśli dotarliśmy aż tu, to nie ma już fragmentów do sprawdzenia. Nie znaleźliśmy 
			// żadnych pasujących permutacji, gdyż jeśli byśmy taką znajdziemy, 
			// to natychmiast zakończylibyśmy działanie funkcji

			return false;
		}
	};

	void test(bool showDetails)
	{
		{
			using namespace x4;

            assert(tryFindPermutation("abc", "cabbage"));
            assert(tryFindPermutation("abc", "abacus"));
            assert(!tryFindPermutation("abc", "scramble"));
            assert(!tryFindPermutation("abc", "brackish"));
            assert(tryFindPermutation("aabb", "cabbage"));
            assert(!tryFindPermutation("aaabb", "cabbage"));
		}
	}

	RegisterTest rt("Reguła 18.", test);
};
