
#include <vector>
#include <assert.h>
#include "tests.h"

using namespace std;

namespace rule15
{
	namespace x1
	{
		// @brief Usunąć z wektora powtarzające się liczby całkowite
		//
		// @param values Wektor liczb całkowitych do skompresowania

		template <class T>
		void compressVector(
			vector<T> & values, 
			bool (* is_equal)(const T &, const T &))
		{
			if (values.size() == 0)
				return;

			int iDst = 1;

			for (int iSrc = 1, c = values.size(); iSrc < c; ++iSrc) {
				// Sprawdzamy unikane wartości
				if (!is_equal(values[iDst - 1], values[iSrc]))
				{
					values[iDst++] = values[iSrc];
				}
			}

			values.resize(iDst);
		}
	};

	namespace x2
	{
		// @brief Kompresuje sekwencje tych samych wartości zapisane w wektorze
		//
		// Z każdej z zapisanych w wektorze sekwencji równych wartości należy usunąć
		// duplikaty i pozostawić jedynie pierwszą z wartości
		//
		// @param values Wektor do kompresji
		// @param is_equal Funkcja porównująca, której należy używać

		template <class T>
		void compressVector(
			vector<T> & values, 
			bool (* is_equal)(const T &, const T &))
		{
			if (values.size() == 0)
				return;

			int iDst = 1;

			for (int iSrc = 1, c = values.size(); iSrc < c; ++iSrc) {
				// Sprawdzamy unikalne wartości
				if (!is_equal(values[iDst - 1], values[iSrc]))
				{
					values[iDst++] = values[iSrc];
				}
			}

			values.resize(iDst);
		}
	};

	namespace x3
	{
		// @brief Kompresuje sekwencje tych samych wartości zapisane w wektorze
		//
		// Z każdej z zapisanych w wektorze sekwencji równych wartości należy usunąć
		// duplikaty i pozostawić jedynie pierwszą z wartości
		//
		// @param values Wektor do kompresji
		// @param is_equal Funkcja porównująca, której należy używać

		template <class T>
		void compressVector(
			vector<T> & values, 
			bool (* isEqual)(const T &, const T &))
		{
			int count = values.size();
			if (count == 0)
				return;

			// Kopiujemy tylko unikalne wartości, pomijając pierwszą

			int destIndex = 1;
			for (int sourceIndex = 1; sourceIndex < count; ++sourceIndex) 
			{
				if (!isEqual(values[destIndex - 1], values[sourceIndex]))
				{
					values[destIndex++] = values[sourceIndex];
				}
			}

			values.resize(destIndex);
		}
	};

	bool isEqual(const int & left, const int & right)
	{
		return left == right;
	}

	void test(bool showDetails)
	{
		{
			using namespace x1;

			vector<int> values;
			vector<int> expectedValues;

			values = { 1, 1, 2, 3, 3, 3, 4, 1, 1, 2, 5, 5, 3, 3, 3 };
			expectedValues = { 1, 2, 3, 4, 1, 2, 5, 3 };

			compressVector(values, isEqual);
			assert(values == expectedValues);

			values = { 0 };
			expectedValues = { 0 };

			compressVector(values, isEqual);
			assert(values == expectedValues);

			values = {};
			expectedValues = {};

			compressVector(values, isEqual);
			assert(values == expectedValues);
		}

		{
			using namespace x2;

			vector<int> values;
			vector<int> expectedValues;

			values = { 1, 1, 2, 3, 3, 3, 4, 1, 1, 2, 5, 5, 3, 3, 3 };
			expectedValues = { 1, 2, 3, 4, 1, 2, 5, 3 };

			compressVector(values, isEqual);
			assert(values == expectedValues);

			values = { 0 };
			expectedValues = { 0 };

			compressVector(values, isEqual);
			assert(values == expectedValues);

			values = {};
			expectedValues = {};

			compressVector(values, isEqual);
			assert(values == expectedValues);
		}

		{
			using namespace x3;

			vector<int> values;
			vector<int> expectedValues;

			values = { 1, 1, 2, 3, 3, 3, 4, 1, 1, 2, 5, 5, 3, 3, 3 };
			expectedValues = { 1, 2, 3, 4, 1, 2, 5, 3 };

			compressVector(values, isEqual);
			assert(values == expectedValues);

			values = { 0 };
			expectedValues = { 0 };

			compressVector(values, isEqual);
			assert(values == expectedValues);

			values = {};
			expectedValues = {};

			compressVector(values, isEqual);
			assert(values == expectedValues);
		}
	}

	RegisterTest rt("Reguła 15.", test);
};
