import { Suspense } from 'react';
import { useLoaderData, Await } from 'react-router-dom';
import { assertIsPosts } from './getPosts';
import { PostData, NewPostData } from './types';
import { PostsList } from './PostsList';
import { savePost } from './savePost';
import { NewPostForm } from './NewPostForm';

export function PostsPage() {
  const data = useLoaderData();
  assertIsData(data);
  async function handleSave(newPostData: NewPostData) {
    await savePost(newPostData);
  }

  return (
    <div className="w-96 mx-auto mt-6">
      <h2 className="text-xl text-slate-900 font-bold">Posty</h2>
      <NewPostForm onSave={handleSave} />
      <Suspense fallback={<div>Pobieranie...</div>}>
        <Await resolve={data.posts}>
          {(posts) => {
            assertIsPosts(posts);
            return <PostsList posts={posts} />;
          }}
        </Await>
      </Suspense>
    </div>
  );
}

type Data = {
  posts: PostData[];
};
export function assertIsData(data: unknown): asserts data is Data {
  if (typeof data !== 'object') {
    throw new Error("Data nie jest obiektem");
  }
  if (data === null) {
    throw new Error('Data jest null');
  }
  if (!('posts' in data)) {
    throw new Error("data nie zawiera postów");
  }
}
