import { Suspense } from 'react';
import { useLoaderData, Await } from 'react-router-dom';
import { useQuery, useMutation, useQueryClient } from '@tanstack/react-query';
import { assertIsPosts, getPosts } from './getPosts';
import { PostData } from './types';
import { PostsList } from './PostsList';
import { savePost } from './savePost';
import { NewPostForm } from './NewPostForm';

export function PostsPage() {
  const { isLoading, data: posts } = useQuery(['postsData'], getPosts);
  const queryClient = useQueryClient();
  const { mutate } = useMutation(savePost, {
    onSuccess: (savedPost) => {
      queryClient.setQueryData<PostData[]>(['postsData'], (oldPosts) => {
        if (oldPosts === undefined) {
          return [savedPost];
        } else {
          return [savedPost, ...oldPosts];
        }
      });
    },
  });

  //   const data = useLoaderData();
  //   assertIsData(data);

  if (isLoading || posts === undefined) {
    return <div className="w-96 mx-auto mt-6">Ładowanie ...</div>;
  }
  return (
    <div className="w-96 mx-auto mt-6">
      <h2 className="text-xl text-slate-900 font-bold">Posty</h2>
      <NewPostForm onSave={mutate} />
      <PostsList posts={posts} />

      {/* <Suspense fallback={<div>Pobieranie...</div>}>
        <Await resolve={data.posts}>
          {(posts) => {
            assertIsPosts(posts);
            return <PostsList posts={posts} />;
          }}
        </Await>
      </Suspense> */}
    </div>
  );
}

type Data = {
  posts: PostData[];
};
export function assertIsData(data: unknown): asserts data is Data {
  if (typeof data !== 'object') {
    throw new Error("Data nie jest obiektem");
  }
  if (data === null) {
    throw new Error('Data jest null');
  }
  if (!('posts' in data)) {
    throw new Error("data nie zawiera postów");
  }
}
