import { Form, ActionFunctionArgs, redirect } from 'react-router-dom';

type Contact = {
  name: string;
  email: string;
  reason: string;
  notes: string;
};

export function ContactPage() {
  const fieldStyle = 'flex flex-col mb-2';

  return (
    <div className="flex flex-col py-10 max-w-md mx-auto">
      <h2 className="text-3xl font-bold underline mb-3">Skontaktuj się z nami</h2>
      <p className="mb-3">
        Jeśli podasz szczegóły, odezwiemy się do Ciebie tak szybko, jak to możliwe.
      </p>
      <Form method="post">
        <div className={fieldStyle}>
          <label htmlFor="name">Imię</label>
          <input type="text" id="name" name="name" required />
        </div>
        <div className={fieldStyle}>
          <label htmlFor="email">Adres e-mail</label>
          <input type="email" id="email" name="email" required pattern="\S+@\S+\.\S+" />
        </div>
        <div className={fieldStyle}>
          <label htmlFor="reason">Powód kontaktu</label>
          <select id="reason" name="reason" required>
            <option value=""></option>
            <option value="Support">Wsparcie</option>
            <option value="Feedback">Opinie</option>
            <option value="Other">Inne</option>
          </select>
        </div>
        <div className={fieldStyle}>
          <label htmlFor="notes">Dodatkowe informacje</label>
          <textarea id="notes" name="notes" />
        </div>
        <div>
          <button type="submit" className="mt-2 h-10 px-6 font-semibold bg-black text-white">
            Wyślij
          </button>
        </div>
      </Form>
    </div>
  );
}

export async function contactPageAction({ request }: ActionFunctionArgs) {
  const formData = await request.formData();
  const contact = {
    name: formData.get('name'),
    email: formData.get('email'),
    reason: formData.get('reason'),
    notes: formData.get('notes'),
  } as Contact;

  console.log('Submitted details:', contact);

  return redirect(`/thank-you/${formData.get('name')}`);
}
