# Rozdział 6. Zarządzanie informacjami o stanie Reacta

Stan i właściwości są ze sobią powiązane. Podczas pracy z aplikacjami Reacta tworzy się komponenty powiązane ze sobą na podstawie zachodzących między nimi związków. W przypadku zmiany stanu drzewa komponentów, zmieniają się również właściwości. Przepływ nowych danych przez drzwo powoduje, że określone liści i gałęzie zostają wygenerowane w celu wyświetlenia nowej treści.

## Przykłady

### Komponent StarRating

- Wygenerowanie pięciu gwiazdek - ([uruchom](https://codesandbox.io/s/learning-react-star-rating-1-h7byq?file=/src/StarRating.js))
- Komponent StarRating i właściwości - ([uruchom](https://codesandbox.io/s/learning-react-star-rating-2-zbkuu?file=/src/App.js))
- Komponent StarRating i informacje o stanie - ([uruchom](https://codesandbox.io/s/learning-react-star-rating-3-tpmr9?file=/src/StarRating.js))
- Ukończony komponent StarRating - ([uruchom](https://codesandbox.io/s/learning-react-star-rating-4-gxvb5?file=/src/Star.js))
- Zaawansowany komponent StarRating - ([uruchom](https://codesandbox.io/s/learning-react-star-rating-5-86ngm?file=/src/StarRating.js))

### Praca z kolorami

- Funkcjonalność: wyświetlenie danych koloru - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-1-5r8tr?file=/src/App.js))
- Funkcjonalność: usunięcie koloru, ocena koloru - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-2-iytxb?file=/src/App.js))
- Funkcjonalność: dodanie komponentu koloru z odwołaniami - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-3-kkyn0?file=/src/AddColorForm.js))
- Refaktoryzacja: dodanie kontrolownego komponentu koloru - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-4-sudge?file=/src/AddColorForm.js))
- Refaktoryzacja: zaczep `useInput` - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-5-umj5q?file=/src/hooks.js))
- Funkcjonalność: dodanie koloru do informacji o stanie - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-6-ewxpp?file=/src/App.js))
- Refaktoryzacja: kolory w kontekście - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-7-lg9y3?file=/src/index.js))
- Refaktoryzacja: zaczep `useColors` - ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-8-jqchd?file=/src/ColorProvider.js))
- BONUS: aplikacja organizacji kolorów (z obsługą emotikonów css)- ([uruchom](https://codesandbox.io/s/learning-react-color-organizer-9-ypf8r?file=/src/ColorList.js))
