# 1.	Czym jest React?
React (lub React.js) jest biblioteką JavaScriptu, która upraszcza tworzenie złożonych interfejsów użytkownika. Jest ona udostępniana w formie pakietu react (https://www.npmjs.com/package/react). Można ją łączyć z pakietem react-dom (https://www.npmjs.com/package/react-dom), który pozwala tworzyć zaawansowane, wysoce interaktywne i reaktywne internetowe interfejsy użytkownika.
React jest biblioteką niezależną od platformy, dlatego możesz jej używać także w innych środowiskach. Bardzo ważne jest to, że za pomocą biblioteki React i pakietu (https://www.npmjs.com/package/react-native) możesz budować natywne aplikacje na urządzenia mobilne.
# 2.	Jakie są zalety stosowania Reacta zamiast czystego JavaScriptu?
W czystym JavaScripcie (czyli wtedy, gdy nie korzystasz z żadnych dodatkowych bibliotek lub platform) wszystkie instrukcje musisz pisać samodzielnie.
W prostych aplikacjach internetowych i interfejsach użytkownika zwykle nie stanowi to problemu, jednak w bardziej zaawansowanych rozwiązaniach stosowanie czystego JavaScriptu może szybko stać się bardzo żmudne i prowadzić do błędów (zobacz też następne pytanie dotyczące różnic między kodem imperatywnych a deklaratywnym).
React upraszcza tworzenie złożonych internetowych interfejsów użytkownika, ponieważ „na zapleczu” generuje i wykonuje za programistę instrukcje operujące modelem DOM. Dzięki temu programista może się skupić na opisie pożądanego docelowego stanu interfejsu użytkownika oraz kluczowej logiki biznesowej. Nie musi ręcznie kontrolować wszystkich aktualizacji i zmian interfejsu użytkownika.
# 3.	Czym różni się kod imperatywny od deklaratywnego?
W kodzie imperatywnym musisz zapisać krok po kroku wszystkie instrukcje. Jeśli chcesz rejestrować kliknięcie przycisku i w reakcji na nie zmieniać tekst na ekranie, musisz dodać kod, który konfiguruje potrzebny odbiornik zdarzeń, a następnie napisać kod do wybierania modyfikowanego elementu, a także kod zmieniający tekst tego elementu.
W skomplikowanych interfejsach użytkownika może to prowadzić do dużej ilości dodatkowej pracy i stać się źródłem błędów
W kodzie deklaratywnym nie trzeba pisać wszystkich kroków prowadzących do określonego efektu. Zamiast tego programista musi tylko opisać docelowe stany interfejsu użytkownika i pozwolić jakiejś bibliotece (tu jest to React) określić, jak uzyskać określone stany. Dzięki temu programista może pominąć dodatkową pracę związaną z wybieraniem elementów modelu DOM i ręcznym ich modyfikowaniem. Zamiast tego może się skupić na podstawowej logice biznesowej.
# 4.	Czym jest aplikacja jednostronicowa?
Aplikacja jednostronicowa technicznie jest udostępniana na tylko jednej stronie (za pomocą jednego dokumentu HTML). Ta strona wczytuje kod JavaScript (zwykle połączony z jakąś biblioteką, na przykład Reactem), który odpowiada za aktualizowanie zawartości strony na podstawie różnych działań podejmowanych przez użytkowników.
Użytkownik może mieć wrażenie, że porusza się między różnymi stronami, jednak technicznie na zapleczu aktualizowany jest model DOM tej samej strony. 
Możesz nawet rejestrować zmiany w ścieżce strony, aby aktualizować na ich podstawie model DOM. Dzięki temu wrażenie korzystania z wielu stron jest jeszcze silniejsze. Gdy używasz Reacta, najpopularniejszym pakietem do wykrywania takich zmian w ścieżkach i aktualizowania interfejsu użytkownika na ich podstawie jest React Router (https://www.npmjs.com/package/react-router).
# 5.	Jak możesz tworzyć nowe projekty Reacta? Dlaczego potrzebna jest tak złożona konfiguracja projektu?
Nowe projekty Reacta można tworzyć na różne sposoby. Najpopularniejszym i najłatwiejszym sposobem na przygotowanie nowego projektu Reacta jest zastosowanie narzędzia create-react-app (https://reactjs.org/docs/create-a-new-react-app.html). 
Za pomocą tego narzędzia możesz utworzyć szkielet nowego projektu Reacta obejmujący wszystkie pakiety (na przykład react i react-dom) potrzebne do budowania projektów internetowych za pomocą tej biblioteki. W takich projektach dostępne są też narzędzia do przekształcania kodu i mechanizmy, które umożliwiają korzystanie ze specjalnych rozwiązań takich jak kod JSX (jest to składnia znaczników używana w aplikacjach Reacta).
Aby utworzyć nowy projekt za pomocą tego narzędzia, użyj instrukcji npx create-react-app nazwa-projektu.
Takie projekty udostępniają też serwer roboczy, który można uruchomić za pomocą instrukcji npm start, aby wyświetlić lokalnie aplikację internetową Reacta i obserwować na żywo aktualizacje związane ze zmianami wprowadzanymi w kodzie.
