# 1.	W jaki sposób pobieranie i przesyłanie danych są powiązane z routingiem?
Pobieranie danych w momencie wczytywania nowej strony to bardzo często wykonywane zadanie. Bardzo często zmieniana jest też ścieżka po wykonaniu jakiejś operacji, na przykład po przesłaniu żądania. Dlatego sensowne jest powiązanie tych zadań z routingiem.
Za pomocą biblioteki React Router możesz wczytywać dane tuż przed wyświetleniem strony i przechodzić do innej trasy po zakończeniu określonej operacji.
# 2.	Do czego służą funkcje loader()?
Funkcje loader() są wykonywane przez bibliotekę React Router po aktywowaniu powiązanej z nimi trasy. Funkcja tworząca komponent powiązany z daną trasą jest uruchamiana dopiero po zakończeniu wykonywania funkcji loader().
Dlatego funkcje loader() są zwykle używane do pobierania danych potrzebnych na stronie. Te dane są zwracane przez funkcję loader() i mogą być używane w komponencie za pomocą haczyka useLoaderData() z biblioteki React Router.
# 3.	Do czego służą funkcje action()?
Zarejestrowane dla trasy funkcje action() są wywoływane przez bibliotekę React Router za każdym razem, gdy przesyłany jest formularz powiązany z tą trasą.
W funkcji action() zwykle obsługiwane jest przesyłanie formularza. Ma to postać sprawdzania poprawności danych wejściowych i/lub przesyłania żądania HTTP z wprowadzonymi danymi do API backendu.
Funkcje action() mogą zwracać dowolne dane. Jeśli zwracasz odpowiedź powodującą przekierowanie (na przykład wygenerowaną za pomocą funkcji redirect() z biblioteki React Router), React Router po zakończeniu wykonywania danego zadania przejdzie do nowej strony.
# 4.	Czym różni się element <Form> od elementu <form>?
Domyślny element <form> po przesłaniu formularza automatycznie tworzy i wysyła żądanie HTTP. Musisz zablokować to domyślne działanie (za pomocą wywołania event.preventDefault()), jeśli przy przesyłaniu formularza chcesz wykonywać jakieś inne operacje.
# 5.	Czym różni się haczyk useSubmit() od haczyka useFetcher()?
Oba te haczyki mogą być używane do programowego uruchamiania funkcji action().
Różnica dotyczy tego, że haczyk useFetcher() udostępnia obiekt, który można wykorzystać także do wczytywania danych (na przykład do uruchamiania funkcji loader()). Ponadto haczyk ten nie wymaga zmiany trasy. Możesz więc uruchomić funkcje loader() lub action() bez zmiany strony.
# 6.	Do czego służy funkcja defer()?
Funkcja defer() umożliwia rozpoczęcie wyświetlania komponentu strony powiązanej z trasą bez wcześniejszego oczekiwania na pobranie wszystkich potrzebnych danych. Może to być przydatne, gdy proces wczytywania danych jest długi.
