# 1.	Dlaczego React używa wirtualnej wersji modelu DOM do wykrywania aktualizacji potrzebnych w modelu DOM?
Gdyby React używał rzeczywistego modelu DOM do określania wymaganych aktualizacji interfejsu użytkownika, wykonywanych byłoby wiele niepotrzebnych operacji wyszukiwania i odczytu w modelu DOM.
Operacje związane z rzeczywistym modelem DOM są kosztowne obliczeniowo, dlatego należy minimalizować ich ilość. Z tego powodu React używa wirtualnego modelu DOM do określania oczekiwanej i obecnej struktury modelu DOM oraz ustalania na podstawie różnic między nimi, jakie zmiany są potrzebne. 
# 2.	Jak wykonanie funkcji tworzącej komponent wpływa na rzeczywisty model DOM?
Gdy wykonywana jest funkcja tworząca komponent, początkowo w ogóle nie wpływa to na rzeczywisty model DOM. Dzieje się tak, ponieważ do określania ewentualnych potrzebnych zmian używana jest wirtualna wersja modelu DOM. Dopiero gdy takie zmiany są potrzebne, React komunikuje się z rzeczywistym modelem DOM i wprowadza te modyfikacje (na przykład usuwa element, dodaje element itd.).
# 3.	Które komponenty są dobrymi kandydatami do zastosowania funkcji memo()? Które komponenty słabo się do tego nadają?
Świetnymi kandydatami są komponenty na wysokich poziomach drzewa komponentów lub na początku głęboko zagnieżdżonych gałęzi takiego drzewa. Wynika to z tego, że dzięki zapobieganiu niepotrzebnych wywołaniom jednego komponentu tego rodzaju (opakowanego w wywołanie memo()) można uniknąć przetwarzania wielu innych komponentów na niższych poziomach drzewa.
Złymi kandydatami są proste komponenty, których wykonywanie nie jest wymagające obliczeniowo, a także komponenty, które i tak często się zmieniają.
# 4.	Czym funkcja useMemo() różni się od memo()?
Funkcja useMemo(), w odróżnieniu od memo(), nie opakowuje całej funkcji tworzącej komponent, a tylko określone fragmenty jej kodu. Za pomocą funkcji useMemo() możesz częściowo zablokować wykonywanie kodu funkcji tworzącej komponent.
# 5.	Po co stosuje się podział kodu i funkcję lazy()?
Gdy użytkownik po raz pierwszy odwiedza witrynę, trzeba pobrać cały potrzebny w niej kod JavaScript. W złożonych aplikacjach Reacta ilość takiego kodu może być duża, a istnieje wysokie prawdopodobieństwo, że przynajmniej jego część nie będzie początkowo potrzebna.
Dzięki podziałowi kodu (za pomocą funkcji lazy() opakowującej dynamiczne instrukcje importu) można rozbić cały kod na wiele pakietów wczytywanych tylko wtedy, gdy są potrzebne.
