// Zależności
import jwt from 'jsonwebtoken'
import { getBase64 } from '@contentpi/lib'

// Konfiguracja
import config from '../config'

// Uzyskanie wartości secretKey
const {
  security: { secretKey }
} = config

export function jwtVerify(accessToken: any, cb: any): void {
  // Sprawdzanie wartości accessToken
  jwt.verify(accessToken, secretKey, (error: any, accessTokenData: any = {}) => {
    const { data: user } = accessTokenData

    // Wartość false zwracana jest w wypadku uzyskania błędu lub wtedy, gdy użytkownik nie jest połączony
    if (error || !user) {
      return cb(false)
    }

    // Uzyskiwanie danych użytkownika
    const userData = getBase64(user)

    return cb(userData)
  })
}

export async function getUserData(accessToken: any): Promise<any> {
  // Jest to funkcja asynchroniczna pobierająca dane użytkownika z funkcji jwtVerify
  const UserPromise = new Promise(resolve => jwtVerify(accessToken, (user: any) => resolve(user)))

  const user = await UserPromise

  return user
}
