// Zależności
import { Request, Response, NextFunction } from 'express'

// Biblioteka
import { getUserData } from '../jwt'

export const isConnected = (isLogged = true, privileges = ['user'], redirectTo = '/') => async (
  req: Request,
  res: Response,
  next: NextFunction
): Promise<void> => {
  // Uzyskanie danych o użytkowniku przez przekazanie informacji cookie tokenu at
  const user = await getUserData(req.cookies.at)

  if (!user && !isLogged) {
    // Powoduje, że dostęp uzyskają tylko połączeni użytkownicy
    return next()
  }

  // Zapewnienie dostępu wyłącznie połączonym użytkownikom i sprawdzanie ważności uprawnień
  if (user && isLogged) {
    // Jeśli użytkownik połączył się i ma uprawnienia konta god
    if (privileges.includes('god') && user.privilege === 'god') {
      return next()
    }

    // Jeśli użytkownik połączył się i ma uprawnienia konta admin
    if (privileges.includes('admin') && user.privilege === 'admin') {
      return next()
    }

    // Jeśli użytkownik połączył się, ale nie ma uprawnień konta god ani admin
    res.redirect(redirectTo)
  } else {
    // Jeśli użytkownik nie połączył się
    res.redirect(redirectTo)
  }
}
