import RPi.GPIO as GPIO
import time
 
GPIO.setmode(GPIO.BCM)
 
coil_A_1_pin = 17
coil_A_2_pin = 4
coil_B_1_pin = 10
coil_B_2_pin = 25
 
GPIO.setup(coil_A_1_pin, GPIO.OUT)
GPIO.setup(coil_A_2_pin, GPIO.OUT)
GPIO.setup(coil_B_1_pin, GPIO.OUT)
GPIO.setup(coil_B_2_pin, GPIO.OUT)

forward_seq = ['1011', '1111', '1110', '1010']
reverse_seq = list(forward_seq) # w celu skopiowania listy
reverse_seq.reverse()
 
def forward(delay, steps):  
  for i in range(steps):
    for step in forward_seq:
      set_step(step)
      time.sleep(delay)
 
def backwards(delay, steps):  
  for i in range(steps):
    for step in reverse_seq:
      set_step(step)
      time.sleep(delay)
 
  
def set_step(step):
  GPIO.output(coil_A_1_pin, step[0] == '1')
  GPIO.output(coil_A_2_pin, step[1] == '1')
  GPIO.output(coil_B_1_pin, step[2] == '1')
  GPIO.output(coil_B_2_pin, step[3] == '1')
 
while True:
  set_step('0000')
  delay = raw_input("Jaki odstep pomiedzy krokami(milisekundy)?")
  steps = raw_input("Ile krokow do przodu? ")
  forward(int(delay) / 1000.0, int(steps))
  set_step('0000')
  steps = raw_input("Ile krokow do tylu? ")
  backwards(int(delay) / 1000.0, int(steps))
